/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.collection.commons.CommonsArrayList;
import com.helger.pgcc.parser.BNFProduction;
import com.helger.pgcc.parser.Container;
import com.helger.pgcc.parser.ETokenKind;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.RegExprSpec;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import com.helger.pgcc.parser.exp.AbstractExpRegularExpression;
import com.helger.pgcc.parser.exp.ExpAction;
import com.helger.pgcc.parser.exp.ExpREndOfFile;
import com.helger.pgcc.parser.exp.ExpTryBlock;
import com.helger.pgcc.parser.exp.Expansion;
import java.util.HashMap;
import java.util.List;

public abstract class JavaCCParserInternals {
    private static List<Token> s_add_cu_token_here = JavaCCGlobals.CU_TO_INSERTION_POINT_1;
    private static Token s_first_cu_token;
    private static boolean s_insertionpoint1set;
    private static boolean s_insertionpoint2set;
    private static int s_nextFreeLexState;

    protected static void initialize() {
        Integer n = 0;
        JavaCCGlobals.LEXSTATE_S2I.put("DEFAULT", n);
        JavaCCGlobals.LEXSTATE_I2S.put(n, "DEFAULT");
        JavaCCGlobals.SIMPLE_TOKENS_TABLE.put("DEFAULT", new HashMap());
    }

    protected static void addcuname(String string) {
        JavaCCGlobals.s_cu_name = string;
    }

    protected static void compare(Token token, String string, String string2) {
        if (!string2.equals(string)) {
            JavaCCErrors.parse_error(token, "Name " + string2 + " must be the same as that used at PARSER_BEGIN (" + string + ")");
        }
    }

    protected static void setinsertionpoint(Token token, int n) {
        do {
            s_add_cu_token_here.add(s_first_cu_token);
        } while ((s_first_cu_token = JavaCCParserInternals.s_first_cu_token.next) != token);
        if (n == 1) {
            if (s_insertionpoint1set) {
                JavaCCErrors.parse_error(token, "Multiple declaration of parser class.");
            } else {
                s_insertionpoint1set = true;
                s_add_cu_token_here = JavaCCGlobals.CU_TO_INSERTION_POINT_2;
            }
        } else {
            s_add_cu_token_here = JavaCCGlobals.CU_FROM_INSERTION_POINT_2;
            s_insertionpoint2set = true;
        }
        s_first_cu_token = token;
    }

    protected static void insertionpointerrors(Token token) {
        while (s_first_cu_token != token) {
            s_add_cu_token_here.add(s_first_cu_token);
            s_first_cu_token = JavaCCParserInternals.s_first_cu_token.next;
        }
        if (!s_insertionpoint1set || !s_insertionpoint2set) {
            JavaCCErrors.parse_error(token, "Parser class has not been defined between PARSER_BEGIN and PARSER_END.");
        }
    }

    protected static void set_initial_cu_token(Token token) {
        s_first_cu_token = token;
    }

    protected static void addProduction(NormalProduction normalProduction) {
        JavaCCGlobals.BNF_PRODUCTIONS.add(normalProduction);
    }

    protected static void productionAddExpansion(BNFProduction bNFProduction, Expansion expansion) {
        expansion.setParent(bNFProduction);
        bNFProduction.setExpansion(expansion);
    }

    protected static void addregexpr(TokenProduction tokenProduction) {
        JavaCCGlobals.REXPR_LIST.add(tokenProduction);
        if (Options.isUserTokenManager() && (tokenProduction.m_lexStates == null || tokenProduction.m_lexStates.length != 1 || !tokenProduction.m_lexStates[0].equals("DEFAULT"))) {
            JavaCCErrors.warning(tokenProduction, "Ignoring lexical state specifications since option USER_TOKEN_MANAGER has been set to true.");
        }
        if (tokenProduction.m_lexStates == null) {
            return;
        }
        for (int i = 0; i < tokenProduction.m_lexStates.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!tokenProduction.m_lexStates[i].equals(tokenProduction.m_lexStates[j])) continue;
                JavaCCErrors.parse_error(tokenProduction, "Multiple occurrence of \"" + tokenProduction.m_lexStates[i] + "\" in lexical state list.");
            }
            if (JavaCCGlobals.LEXSTATE_S2I.get(tokenProduction.m_lexStates[i]) != null) continue;
            Integer n = s_nextFreeLexState;
            ++s_nextFreeLexState;
            JavaCCGlobals.LEXSTATE_S2I.put(tokenProduction.m_lexStates[i], n);
            JavaCCGlobals.LEXSTATE_I2S.put(n, tokenProduction.m_lexStates[i]);
            JavaCCGlobals.SIMPLE_TOKENS_TABLE.put(tokenProduction.m_lexStates[i], new HashMap());
        }
    }

    protected static void add_token_manager_decls(Token token, List<Token> list) {
        if (JavaCCGlobals.s_token_mgr_decls != null) {
            JavaCCErrors.parse_error(token, "Multiple occurrence of \"TOKEN_MGR_DECLS\".");
        } else {
            JavaCCGlobals.s_token_mgr_decls = new CommonsArrayList(list);
            if (Options.isUserTokenManager()) {
                JavaCCErrors.warning(token, "Ignoring declarations in \"TOKEN_MGR_DECLS\" since option USER_TOKEN_MANAGER has been set to true.");
            }
        }
    }

    protected static void add_inline_regexpr(AbstractExpRegularExpression abstractExpRegularExpression) {
        if (!(abstractExpRegularExpression instanceof ExpREndOfFile)) {
            TokenProduction tokenProduction = new TokenProduction();
            tokenProduction.m_isExplicit = false;
            tokenProduction.m_lexStates = new String[]{"DEFAULT"};
            tokenProduction.m_kind = ETokenKind.TOKEN;
            RegExprSpec regExprSpec = new RegExprSpec();
            regExprSpec.rexp = abstractExpRegularExpression;
            regExprSpec.rexp.m_tpContext = tokenProduction;
            regExprSpec.act = new ExpAction();
            regExprSpec.nextState = null;
            regExprSpec.nsTok = null;
            tokenProduction.m_respecs.add(regExprSpec);
            JavaCCGlobals.REXPR_LIST.add(tokenProduction);
        }
    }

    private static boolean _isHexchar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'F') {
            return true;
        }
        return c >= 'a' && c <= 'f';
    }

    private static int _getHexVal(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return c - 97 + 10;
    }

    protected static String remove_escapes_and_quotes(Token token, String string) {
        Object object = "";
        int n = 1;
        while (n < string.length() - 1) {
            int n2;
            char c;
            if (string.charAt(n) != '\\') {
                object = (String)object + string.charAt(n);
                ++n;
                continue;
            }
            if ((c = string.charAt(++n)) == 'b') {
                object = (String)object + "\b";
                ++n;
                continue;
            }
            if (c == 't') {
                object = (String)object + "\t";
                ++n;
                continue;
            }
            if (c == 'n') {
                object = (String)object + "\n";
                ++n;
                continue;
            }
            if (c == 'f') {
                object = (String)object + "\f";
                ++n;
                continue;
            }
            if (c == 'r') {
                object = (String)object + "\r";
                ++n;
                continue;
            }
            if (c == '\"') {
                object = (String)object + "\"";
                ++n;
                continue;
            }
            if (c == '\'') {
                object = (String)object + "'";
                ++n;
                continue;
            }
            if (c == '\\') {
                object = (String)object + "\\";
                ++n;
                continue;
            }
            if (c >= '0' && c <= '7') {
                char c2;
                n2 = c - 48;
                if ((c2 = string.charAt(++n)) >= '0' && c2 <= '7') {
                    n2 = n2 * 8 + c2 - 48;
                    c2 = string.charAt(++n);
                    if (c <= '3' && c2 >= '0' && c2 <= '7') {
                        n2 = n2 * 8 + c2 - 48;
                        ++n;
                    }
                }
                object = (String)object + (char)n2;
                continue;
            }
            if (c == 'u') {
                if (JavaCCParserInternals._isHexchar(c = string.charAt(++n))) {
                    n2 = JavaCCParserInternals._getHexVal(c);
                    if (JavaCCParserInternals._isHexchar(c = string.charAt(++n))) {
                        n2 = n2 * 16 + JavaCCParserInternals._getHexVal(c);
                        if (JavaCCParserInternals._isHexchar(c = string.charAt(++n))) {
                            n2 = n2 * 16 + JavaCCParserInternals._getHexVal(c);
                            if (JavaCCParserInternals._isHexchar(c = string.charAt(++n))) {
                                n2 = n2 * 16 + JavaCCParserInternals._getHexVal(c);
                                ++n;
                                continue;
                            }
                        }
                    }
                }
                JavaCCErrors.parse_error(token, "Encountered non-hex character '" + c + "' at position " + n + " of string - Unicode escape must have 4 hex digits after it.");
                return object;
            }
            JavaCCErrors.parse_error(token, "Illegal escape sequence '\\" + c + "' at position " + n + " of string.");
            return object;
        }
        return object;
    }

    protected static char character_descriptor_assign(Token token, String string) {
        if (string.length() != 1) {
            JavaCCErrors.parse_error(token, "String in character list may contain only one character.");
            return ' ';
        }
        return string.charAt(0);
    }

    protected static char character_descriptor_assign(Token token, String string, String string2) {
        if (string.length() != 1) {
            JavaCCErrors.parse_error(token, "String in character list may contain only one character.");
            return ' ';
        }
        if (string2.charAt(0) > string.charAt(0)) {
            JavaCCErrors.parse_error(token, "Right end of character range '" + string + "' has a lower ordinal value than the left end of character range '" + string2 + "'.");
            return string2.charAt(0);
        }
        return string.charAt(0);
    }

    protected static void makeTryBlock(Token token, Container container, Container container2, List<List<Token>> list, List<Token> list2, List<List<Token>> list3, List<Token> list4) {
        if (list3.size() == 0 && list4 == null) {
            JavaCCErrors.parse_error(token, "Try block must contain at least one catch or finally block.");
            return;
        }
        ExpTryBlock expTryBlock = new ExpTryBlock();
        expTryBlock.setLine(token.beginLine);
        expTryBlock.setColumn(token.beginColumn);
        expTryBlock.m_exp = (Expansion)container2.member;
        expTryBlock.m_exp.setParent(expTryBlock);
        expTryBlock.m_exp.setOrdinalBase(0);
        expTryBlock.m_types = list;
        expTryBlock.m_ids = list2;
        expTryBlock.m_catchblks = list3;
        expTryBlock.m_finallyblk = list4;
        container.member = expTryBlock;
    }

    public static void reInit() {
        s_add_cu_token_here = JavaCCGlobals.CU_TO_INSERTION_POINT_1;
        s_first_cu_token = null;
        s_insertionpoint1set = false;
        s_insertionpoint2set = false;
        s_nextFreeLexState = 1;
    }

    static {
        s_insertionpoint1set = false;
        s_insertionpoint2set = false;
        s_nextFreeLexState = 1;
    }

    public static final class ModifierSet {
        public static final int PUBLIC = 1;
        public static final int PROTECTED = 2;
        public static final int PRIVATE = 4;
        public static final int ABSTRACT = 8;
        public static final int STATIC = 16;
        public static final int FINAL = 32;
        public static final int SYNCHRONIZED = 64;
        public static final int NATIVE = 128;
        public static final int TRANSIENT = 256;
        public static final int VOLATILE = 512;
        public static final int STRICTFP = 4096;

        private ModifierSet() {
        }

        public static boolean isPublic(int n) {
            return (n & 1) != 0;
        }

        public static boolean isProtected(int n) {
            return (n & 2) != 0;
        }

        public static boolean isPrivate(int n) {
            return (n & 4) != 0;
        }

        public static boolean isStatic(int n) {
            return (n & 0x10) != 0;
        }

        public static boolean isAbstract(int n) {
            return (n & 8) != 0;
        }

        public static boolean isFinal(int n) {
            return (n & 0x20) != 0;
        }

        public static boolean isNative(int n) {
            return (n & 0x80) != 0;
        }

        public static boolean isStrictfp(int n) {
            return (n & 0x1000) != 0;
        }

        public static boolean isSynchronized(int n) {
            return (n & 0x40) != 0;
        }

        public static boolean isTransient(int n) {
            return (n & 0x100) != 0;
        }

        public static boolean isVolatile(int n) {
            return (n & 0x200) != 0;
        }

        static int removeModifier(int n, int n2) {
            return n & ~n2;
        }
    }
}

