/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.system.SystemHelper;
import com.helger.pgcc.EJDKVersion;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.utils.EOptionType;
import com.helger.pgcc.utils.OptionInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Options {
    public static final String NONUSER_OPTION__NAMESPACE_CLOSE = "NAMESPACE_CLOSE";
    public static final String NONUSER_OPTION__HAS_NAMESPACE = "HAS_NAMESPACE";
    public static final String NONUSER_OPTION__NAMESPACE_OPEN = "NAMESPACE_OPEN";
    public static final String NONUSER_OPTION__PARSER_NAME = "PARSER_NAME";
    public static final String USEROPTION__PARSER_SUPER_CLASS = "PARSER_SUPER_CLASS";
    public static final String USEROPTION__JAVA_TEMPLATE_TYPE = "JAVA_TEMPLATE_TYPE";
    public static final String USEROPTION__GENERATE_BOILERPLATE = "GENERATE_BOILERPLATE";
    public static final String USEROPTION__OUTPUT_LANGUAGE = "OUTPUT_LANGUAGE";
    public static final String USEROPTION__PARSER_CODE_GENERATOR = "PARSER_CODE_GENERATOR";
    public static final String USEROPTION__TOKEN_MANAGER_CODE_GENERATOR = "TOKEN_MANAGER_CODE_GENERATOR";
    public static final String USEROPTION__NO_DFA = "NO_DFA";
    public static final String USEROPTION__TOKEN_MANAGER_SUPER_CLASS = "TOKEN_MANAGER_SUPER_CLASS";
    public static final String USEROPTION__LOOKAHEAD = "LOOKAHEAD";
    public static final String USEROPTION__IGNORE_CASE = "IGNORE_CASE";
    public static final String USEROPTION__UNICODE_INPUT = "UNICODE_INPUT";
    public static final String USEROPTION__JAVA_UNICODE_ESCAPE = "JAVA_UNICODE_ESCAPE";
    public static final String USEROPTION__ERROR_REPORTING = "ERROR_REPORTING";
    public static final String USEROPTION__DEBUG_TOKEN_MANAGER = "DEBUG_TOKEN_MANAGER";
    public static final String USEROPTION__DEBUG_LOOKAHEAD = "DEBUG_LOOKAHEAD";
    public static final String USEROPTION__DEBUG_PARSER = "DEBUG_PARSER";
    public static final String USEROPTION__OTHER_AMBIGUITY_CHECK = "OTHER_AMBIGUITY_CHECK";
    public static final String USEROPTION__CHOICE_AMBIGUITY_CHECK = "CHOICE_AMBIGUITY_CHECK";
    public static final String USEROPTION__CACHE_TOKENS = "CACHE_TOKENS";
    public static final String USEROPTION__COMMON_TOKEN_ACTION = "COMMON_TOKEN_ACTION";
    public static final String USEROPTION__FORCE_LA_CHECK = "FORCE_LA_CHECK";
    public static final String USEROPTION__SANITY_CHECK = "SANITY_CHECK";
    public static final String USEROPTION__TOKEN_MANAGER_USES_PARSER = "TOKEN_MANAGER_USES_PARSER";
    public static final String USEROPTION__BUILD_TOKEN_MANAGER = "BUILD_TOKEN_MANAGER";
    public static final String USEROPTION__BUILD_PARSER = "BUILD_PARSER";
    public static final String USEROPTION__USER_CHAR_STREAM = "USER_CHAR_STREAM";
    public static final String USEROPTION__USER_TOKEN_MANAGER = "USER_TOKEN_MANAGER";
    public static final String USEROPTION__JDK_VERSION = "JDK_VERSION";
    public static final String USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC = "SUPPORT_CLASS_VISIBILITY_PUBLIC";
    public static final String USEROPTION__OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String USEROPTION__KEEP_LINE_COLUMN = "KEEP_LINE_COLUMN";
    public static final String USEROPTION__GRAMMAR_ENCODING = "GRAMMAR_ENCODING";
    public static final String USEROPTION__OUTPUT_ENCODING = "OUTPUT_ENCODING";
    public static final String USEROPTION__TOKEN_FACTORY = "TOKEN_FACTORY";
    public static final String USEROPTION__TOKEN_EXTENDS = "TOKEN_EXTENDS";
    public static final String USEROPTION__DEPTH_LIMIT = "DEPTH_LIMIT";
    public static final String USEROPTION__CPP_NAMESPACE = "NAMESPACE";
    public static final String USEROPTION__CPP_TOKEN_INCLUDES = "TOKEN_INCLUDES";
    public static final String USEROPTION__CPP_PARSER_INCLUDES = "PARSER_INCLUDES";
    public static final String USEROPTION__CPP_IGNORE_ACTIONS = "IGNORE_ACTIONS";
    public static final String USEROPTION__CPP_TOKEN_MANAGER_INCLUDES = "TOKEN_MANAGER_INCLUDES";
    public static final String USEROPTION__CPP_TOKEN_MANAGER_SUPERCLASS = "TOKEN_MANAGER_SUPERCLASS";
    public static final String USEROPTION__CPP_STOP_ON_FIRST_ERROR = "STOP_ON_FIRST_ERROR";
    public static final String USEROPTION__CPP_STACK_LIMIT = "STACK_LIMIT";
    public static final String USEROPTION__CPP_TOKEN_INCLUDE = "TOKEN_INCLUDE";
    public static final String USEROPTION__CPP_PARSER_INCLUDE = "PARSER_INCLUDE";
    private static EOutputLanguage s_language = EOutputLanguage.JAVA;
    public static final String JAVA_TEMPLATE_TYPE_MODERN = "modern";
    public static final String JAVA_TEMPLATE_TYPE_CLASSIC = "classic";
    private static final Set<OptionInfo> s_userOptions;
    protected static final Map<String, Object> s_optionValues;
    private static final Set<String> s_cmdLineSetting;
    private static final Set<String> s_inputFileSetting;
    private static final Set<String> s_aSupportedJavaTemplateTypes;

    protected Options() {
    }

    public static void init() {
        s_optionValues.clear();
        s_cmdLineSetting.clear();
        s_inputFileSetting.clear();
        for (OptionInfo optionInfo : s_userOptions) {
            s_optionValues.put(optionInfo.getName(), optionInfo.getDefault());
        }
        s_language = EOutputLanguage.JAVA;
    }

    @Nullable
    public static Object objectValue(String string) {
        return s_optionValues.get(string);
    }

    public static int intValue(String string) {
        return (Integer)Options.objectValue(string);
    }

    public static boolean booleanValue(String string) {
        return (Boolean)Options.objectValue(string);
    }

    @Nullable
    public static String stringValue(String string) {
        return (String)Options.objectValue(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, Object> getAllOptions() {
        return new HashMap<String, Object>(s_optionValues);
    }

    @Nonnull
    public static String getOptionsString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string).append('=').append(s_optionValues.get(string));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getTokenMgrErrorClass() {
        switch (s_language) {
            case JAVA: {
                return "TokenMgrException";
            }
            case CPP: {
                return "TokenMgrError";
            }
        }
        throw new UnsupportedOutputLanguageException(s_language);
    }

    public static boolean isOption(String string) {
        return string != null && string.length() > 1 && string.charAt(0) == '-';
    }

    @Nonnull
    private static Object _upgradeValue(@Nonnull String string, @Nonnull Object object) {
        EJDKVersion eJDKVersion;
        if (string.equalsIgnoreCase("NODE_FACTORY") && object.getClass() == Boolean.class) {
            return (Boolean)object != false ? "*" : "";
        }
        if (string.equalsIgnoreCase(USEROPTION__JDK_VERSION) && (object.getClass() == String.class || object.getClass() == Integer.class) && (eJDKVersion = EJDKVersion.getFromStringOrNull(object.toString())) != null && eJDKVersion.isNewerOrEqualsThan(EJDKVersion.JDK_1_5)) {
            return eJDKVersion;
        }
        return object;
    }

    public static void setInputFileOption(Object object, Object object2, @Nonnull String string, @Nonnull Object object3) {
        Object object4;
        String string2 = string.toUpperCase(Locale.US);
        if (!s_optionValues.containsKey(string2)) {
            JavaCCErrors.warning(object, "Bad option name \"" + string + "\".  Option setting will be ignored.");
            return;
        }
        Object object5 = s_optionValues.get(string2);
        Object object6 = Options._upgradeValue(string, object3);
        if (object5 != null) {
            boolean bl;
            object4 = null;
            object4 = object6 instanceof List ? ((List)object6).get(0) : object6;
            boolean bl2 = bl = object4 instanceof Integer && (Integer)object6 <= 0;
            if (object5.getClass() != object4.getClass() || bl) {
                JavaCCErrors.warning(object2, "Bad option value \"" + String.valueOf(object6) + "\" for \"" + string + "\".  Option setting will be ignored.");
                return;
            }
            if (s_inputFileSetting.contains(string2)) {
                JavaCCErrors.warning(object, "Duplicate option setting for \"" + string + "\" will be ignored.");
                return;
            }
            if (s_cmdLineSetting.contains(string2)) {
                if (!object5.equals(object6)) {
                    JavaCCErrors.warning(object, "Command line setting of \"" + string + "\" modifies option value in file.");
                }
                return;
            }
        }
        s_optionValues.put(string2, object6);
        s_inputFileSetting.add(string2);
        if (string2.equalsIgnoreCase(USEROPTION__JAVA_TEMPLATE_TYPE)) {
            object4 = (String)object6;
            if (!Options._isValidJavaTemplateType((String)object4)) {
                JavaCCErrors.warning(object2, "Bad option value \"" + String.valueOf(object6) + "\" for \"" + string + "\".  Option setting will be ignored. Valid options are: " + StringImplode.imploder().source(s_aSupportedJavaTemplateTypes).separator(", ").build());
            }
        } else if (string2.equalsIgnoreCase(USEROPTION__OUTPUT_LANGUAGE)) {
            object4 = (String)object6;
            EOutputLanguage eOutputLanguage = EOutputLanguage.getFromIDCaseInsensitiveOrNull((String)object4);
            if (eOutputLanguage == null) {
                JavaCCErrors.warning(object2, "Bad option value \"" + String.valueOf(object6) + "\" for \"" + string + "\".  Option setting will be ignored. Valid options are: " + StringImplode.imploder().source((Object[])EOutputLanguage.values(), EOutputLanguage::getID).separator(", ").build());
                return;
            }
            s_language = eOutputLanguage;
        } else if (string2.equalsIgnoreCase(USEROPTION__CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption((String)object6);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setCmdLineOption(@Nonnull String string) {
        Object object;
        Object object2;
        String string2;
        block15: {
            int n;
            String string3;
            block16: {
                string3 = string.charAt(0) == '-' ? string.substring(1) : string;
                int n2 = string3.indexOf(61);
                int n3 = string3.indexOf(58);
                n = n2 < 0 ? n3 : (n3 < 0 ? n2 : Math.min(n2, n3));
                if (n >= 0) break block16;
                string2 = string3.toUpperCase(Locale.US);
                if (s_optionValues.containsKey(string2)) {
                    object2 = Boolean.TRUE;
                    break block15;
                } else if (string2.length() > 2 && string2.charAt(0) == 'N' && string2.charAt(1) == 'O' && s_optionValues.containsKey(string2.substring(2))) {
                    object2 = Boolean.FALSE;
                    string2 = string2.substring(2);
                    break block15;
                } else {
                    PGPrinter.warn("Warning: Bad option \"" + string + "\" will be ignored.");
                    return;
                }
            }
            string2 = string3.substring(0, n).toUpperCase(Locale.US);
            object = string3.substring(n + 1);
            if (((String)object).equalsIgnoreCase("TRUE")) {
                object2 = Boolean.TRUE;
            } else if (((String)object).equalsIgnoreCase("FALSE")) {
                object2 = Boolean.FALSE;
            } else {
                try {
                    int n4 = Integer.parseInt((String)object);
                    if (n4 <= 0) {
                        PGPrinter.warn("Warning: Bad option value in \"" + string + "\" will be ignored.");
                        return;
                    }
                    object2 = n4;
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = object;
                    if (((String)object).length() <= 2 || ((String)object).charAt(0) != '\"' || ((String)object).charAt(((String)object).length() - 1) != '\"') break block15;
                    object2 = ((String)object).substring(1, ((String)object).length() - 1);
                }
            }
        }
        if (!s_optionValues.containsKey(string2)) {
            PGPrinter.warn("Warning: Bad option \"" + string + "\" will be ignored.");
            return;
        }
        object2 = Options._upgradeValue(string2, object2);
        object = s_optionValues.get(string2);
        if (object2.getClass() != object.getClass()) {
            PGPrinter.warn("Warning: Bad option value in \"" + string + "\" will be ignored.");
            return;
        }
        if (s_cmdLineSetting.contains(string2)) {
            PGPrinter.warn("Warning: Duplicate option setting \"" + string + "\" will be ignored.");
            return;
        }
        s_optionValues.put(string2, object2);
        s_cmdLineSetting.add(string2);
        if (string2.equalsIgnoreCase(USEROPTION__CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption((String)object2);
        }
    }

    public static void normalize() {
        if (Options.isDebugLookahead() && !Options.isDebugParser()) {
            if (s_cmdLineSetting.contains(USEROPTION__DEBUG_PARSER) || s_inputFileSetting.contains(USEROPTION__DEBUG_PARSER)) {
                JavaCCErrors.warning("True setting of option DEBUG_LOOKAHEAD overrides false setting of option DEBUG_PARSER.");
            }
            s_optionValues.put(USEROPTION__DEBUG_PARSER, Boolean.TRUE);
        }
    }

    public static int getLookahead() {
        return Options.intValue(USEROPTION__LOOKAHEAD);
    }

    public static int getChoiceAmbiguityCheck() {
        return Options.intValue(USEROPTION__CHOICE_AMBIGUITY_CHECK);
    }

    public static int getOtherAmbiguityCheck() {
        return Options.intValue(USEROPTION__OTHER_AMBIGUITY_CHECK);
    }

    @Nullable
    public static String getParserCodeGenerator() {
        String string = Options.stringValue(USEROPTION__PARSER_CODE_GENERATOR);
        return StringHelper.isEmpty((String)string) ? null : string;
    }

    @Nullable
    public static String getTokenManagerCodeGenerator() {
        String string = Options.stringValue(USEROPTION__TOKEN_MANAGER_CODE_GENERATOR);
        return StringHelper.isEmpty((String)string) ? null : string;
    }

    public static boolean isNoDfa() {
        return Options.booleanValue(USEROPTION__NO_DFA);
    }

    public static boolean isDebugParser() {
        return Options.booleanValue(USEROPTION__DEBUG_PARSER);
    }

    public static boolean isDebugLookahead() {
        return Options.booleanValue(USEROPTION__DEBUG_LOOKAHEAD);
    }

    public static boolean isDebugTokenManager() {
        return Options.booleanValue(USEROPTION__DEBUG_TOKEN_MANAGER);
    }

    public static boolean isErrorReporting() {
        return Options.booleanValue(USEROPTION__ERROR_REPORTING);
    }

    public static boolean isJavaUnicodeEscape() {
        return Options.booleanValue(USEROPTION__JAVA_UNICODE_ESCAPE);
    }

    public static boolean isUnicodeInput() {
        return Options.booleanValue(USEROPTION__UNICODE_INPUT);
    }

    public static boolean isIgnoreCase() {
        return Options.booleanValue(USEROPTION__IGNORE_CASE);
    }

    public static boolean isUserTokenManager() {
        return Options.booleanValue(USEROPTION__USER_TOKEN_MANAGER);
    }

    public static boolean isJavaUserCharStream() {
        return Options.booleanValue(USEROPTION__USER_CHAR_STREAM);
    }

    public static boolean isBuildParser() {
        return Options.booleanValue(USEROPTION__BUILD_PARSER);
    }

    public static boolean isBuildTokenManager() {
        return Options.booleanValue(USEROPTION__BUILD_TOKEN_MANAGER);
    }

    public static boolean isTokenManagerUsesParser() {
        return Options.booleanValue(USEROPTION__TOKEN_MANAGER_USES_PARSER);
    }

    public static boolean isSanityCheck() {
        return Options.booleanValue(USEROPTION__SANITY_CHECK);
    }

    public static boolean isForceLaCheck() {
        return Options.booleanValue(USEROPTION__FORCE_LA_CHECK);
    }

    public static boolean isCommonTokenAction() {
        return Options.booleanValue(USEROPTION__COMMON_TOKEN_ACTION);
    }

    public static boolean isCacheTokens() {
        return Options.booleanValue(USEROPTION__CACHE_TOKENS);
    }

    public static boolean isKeepLineColumn() {
        return Options.booleanValue(USEROPTION__KEEP_LINE_COLUMN);
    }

    public static EJDKVersion getJdkVersion() {
        return (EJDKVersion)((Object)Options.objectValue(USEROPTION__JDK_VERSION));
    }

    public static boolean isGenerateJavaBoilerplateCode() {
        return Options.booleanValue(USEROPTION__GENERATE_BOILERPLATE);
    }

    public static boolean isJavaSupportClassVisibilityPublic() {
        return Options.booleanValue(USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC);
    }

    public static String getTokenExtends() {
        return Options.stringValue(USEROPTION__TOKEN_EXTENDS);
    }

    public static String getTokenFactory() {
        return Options.stringValue(USEROPTION__TOKEN_FACTORY);
    }

    @Nonnull
    public static Charset getGrammarEncoding() {
        String string = Options.stringValue(USEROPTION__GRAMMAR_ENCODING);
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                JavaCCErrors.warning("The grammar encoding value '" + string + "' is invalid. Falling back to default.");
            }
        }
        return SystemHelper.getSystemCharset();
    }

    @Nonnull
    public static Charset getOutputEncoding() {
        String string = Options.stringValue(USEROPTION__OUTPUT_ENCODING);
        if (StringHelper.isNotEmpty((String)string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                JavaCCErrors.warning("The output encoding value '" + string + "' is invalid. Falling back to default.");
            }
        }
        return StandardCharsets.UTF_8;
    }

    public static File getOutputDirectory() {
        return new File(Options.stringValue(USEROPTION__OUTPUT_DIRECTORY));
    }

    private static boolean _isValidJavaTemplateType(@Nullable String string) {
        return string == null ? false : s_aSupportedJavaTemplateTypes.contains(string.toLowerCase(Locale.US));
    }

    @Nonnull
    public static EOutputLanguage getOutputLanguage() {
        return s_language;
    }

    public static String getJavaTemplateType() {
        return Options.stringValue(USEROPTION__JAVA_TEMPLATE_TYPE);
    }

    public static void setStringOption(String string, String string2) {
        s_optionValues.put(string, string2);
        if (string.equalsIgnoreCase(USEROPTION__CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption(string2);
        }
    }

    public static void processCPPNamespaceOption(String string) {
        String string2 = string;
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "::");
            String string3 = stringTokenizer.nextToken() + " {";
            Object object = "}";
            while (stringTokenizer.hasMoreTokens()) {
                string3 = string3 + "\nnamespace " + stringTokenizer.nextToken() + " {";
                object = (String)object + "\n}";
            }
            s_optionValues.put(NONUSER_OPTION__NAMESPACE_OPEN, string3);
            s_optionValues.put(NONUSER_OPTION__HAS_NAMESPACE, Boolean.TRUE);
            s_optionValues.put(NONUSER_OPTION__NAMESPACE_CLOSE, object);
        }
    }

    public static boolean isTokenManagerRequiresParserAccess() {
        return Options.isTokenManagerUsesParser();
    }

    public static int getDepthLimit() {
        return Options.intValue(USEROPTION__DEPTH_LIMIT);
    }

    public static boolean hasDepthLimit() {
        return Options.getDepthLimit() > 0;
    }

    public static String getCPPStackLimit() {
        String string = Options.stringValue(USEROPTION__CPP_STACK_LIMIT);
        if (string.equals("0")) {
            return "";
        }
        return string;
    }

    public static boolean hasCPPStackLimit() {
        return StringHelper.isNotEmpty((String)Options.getCPPStackLimit());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<OptionInfo> getUserOptions() {
        return s_userOptions;
    }

    static {
        TreeSet<OptionInfo> treeSet = new TreeSet<OptionInfo>();
        treeSet.add(new OptionInfo(USEROPTION__PARSER_SUPER_CLASS, EOptionType.STRING, null));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_SUPER_CLASS, EOptionType.STRING, null));
        treeSet.add(new OptionInfo(USEROPTION__LOOKAHEAD, EOptionType.INTEGER, Integer.valueOf(1)));
        treeSet.add(new OptionInfo(USEROPTION__CHOICE_AMBIGUITY_CHECK, EOptionType.INTEGER, Integer.valueOf(2)));
        treeSet.add(new OptionInfo(USEROPTION__OTHER_AMBIGUITY_CHECK, EOptionType.INTEGER, Integer.valueOf(1)));
        treeSet.add(new OptionInfo(USEROPTION__PARSER_CODE_GENERATOR, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_CODE_GENERATOR, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__NO_DFA, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__DEBUG_PARSER, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__DEBUG_LOOKAHEAD, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__DEBUG_TOKEN_MANAGER, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__ERROR_REPORTING, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__JAVA_UNICODE_ESCAPE, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__UNICODE_INPUT, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__IGNORE_CASE, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__USER_TOKEN_MANAGER, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__USER_CHAR_STREAM, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__BUILD_PARSER, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__BUILD_TOKEN_MANAGER, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_USES_PARSER, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__SANITY_CHECK, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__FORCE_LA_CHECK, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__COMMON_TOKEN_ACTION, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__CACHE_TOKENS, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__KEEP_LINE_COLUMN, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__GENERATE_BOILERPLATE, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC, EOptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__OUTPUT_DIRECTORY, EOptionType.STRING, (Comparable<?>)((Object)".")));
        treeSet.add(new OptionInfo(USEROPTION__JDK_VERSION, EOptionType.OTHER, (Comparable<?>)((Object)EJDKVersion.DEFAULT)));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_EXTENDS, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_FACTORY, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__GRAMMAR_ENCODING, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__OUTPUT_ENCODING, EOptionType.STRING, (Comparable<?>)((Object)StandardCharsets.UTF_8.name())));
        s_language = EOutputLanguage.JAVA;
        treeSet.add(new OptionInfo(USEROPTION__OUTPUT_LANGUAGE, EOptionType.STRING, (Comparable<?>)((Object)s_language.getID())));
        treeSet.add(new OptionInfo(USEROPTION__JAVA_TEMPLATE_TYPE, EOptionType.STRING, (Comparable<?>)((Object)JAVA_TEMPLATE_TYPE_CLASSIC)));
        treeSet.add(new OptionInfo(USEROPTION__CPP_NAMESPACE, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__CPP_TOKEN_INCLUDES, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__CPP_PARSER_INCLUDES, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__CPP_TOKEN_MANAGER_INCLUDES, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__CPP_IGNORE_ACTIONS, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__CPP_STOP_ON_FIRST_ERROR, EOptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__CPP_TOKEN_MANAGER_SUPERCLASS, EOptionType.STRING, (Comparable<?>)((Object)"")));
        treeSet.add(new OptionInfo(USEROPTION__DEPTH_LIMIT, EOptionType.INTEGER, Integer.valueOf(0)));
        treeSet.add(new OptionInfo(USEROPTION__CPP_STACK_LIMIT, EOptionType.STRING, (Comparable<?>)((Object)"")));
        s_userOptions = Collections.unmodifiableSet(treeSet);
        s_optionValues = new HashMap<String, Object>();
        s_cmdLineSetting = new HashSet<String>();
        s_inputFileSetting = new HashSet<String>();
        s_aSupportedJavaTemplateTypes = new HashSet<String>();
        s_aSupportedJavaTemplateTypes.add(JAVA_TEMPLATE_TYPE_CLASSIC);
        s_aSupportedJavaTemplateTypes.add(JAVA_TEMPLATE_TYPE_MODERN);
    }
}

