/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.AbstractCodeProduction;
import com.helger.pgcc.parser.BNFProduction;
import com.helger.pgcc.parser.CodeGenerator;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Phase3Data;
import com.helger.pgcc.parser.Semanticize;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.exp.AbstractExpRegularExpression;
import com.helger.pgcc.parser.exp.ExpAction;
import com.helger.pgcc.parser.exp.ExpChoice;
import com.helger.pgcc.parser.exp.ExpLookahead;
import com.helger.pgcc.parser.exp.ExpNonTerminal;
import com.helger.pgcc.parser.exp.ExpOneOrMore;
import com.helger.pgcc.parser.exp.ExpSequence;
import com.helger.pgcc.parser.exp.ExpTryBlock;
import com.helger.pgcc.parser.exp.ExpZeroOrMore;
import com.helger.pgcc.parser.exp.ExpZeroOrOne;
import com.helger.pgcc.parser.exp.Expansion;
import jakarta.annotation.Nonnull;
import java.lang.invoke.StringConcatFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ParseEngine {
    private int m_nGenSymbolIndex = 0;
    private int m_nIndentCount = 0;
    private boolean m_bJJ2LA = false;
    private CodeGenerator m_codeGenerator;
    private final ICommonsList<ExpLookahead> m_phase2list = new CommonsArrayList();
    private final ICommonsList<Phase3Data> m_phase3list = new CommonsArrayList();
    private final ICommonsMap<Expansion, Phase3Data> m_phase3table = new CommonsHashMap();
    private static final char INDENT_INC = '\u0001';
    private static final char INDENT_DEC = '\u0002';
    private static final char INDENT_OFF = '\u0003';
    private static final char INDENT_ON = '\u0004';
    private boolean[] m_firstSet;
    private boolean m_xsp_declared;
    private Expansion m_jj3_expansion;

    private boolean _javaCodeCheck(Expansion expansion) {
        if (expansion instanceof AbstractExpRegularExpression) {
            return false;
        }
        if (expansion instanceof ExpNonTerminal) {
            NormalProduction normalProduction = ((ExpNonTerminal)expansion).getProd();
            if (normalProduction instanceof AbstractCodeProduction) {
                return true;
            }
            return this._javaCodeCheck(normalProduction.getExpansion());
        }
        if (expansion instanceof ExpChoice) {
            ExpChoice expChoice = (ExpChoice)expansion;
            for (Expansion expansion2 : expChoice.getChoices()) {
                if (!this._javaCodeCheck(expansion2)) continue;
                return true;
            }
            return false;
        }
        if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            for (int i = 0; i < expSequence.getUnitCount(); ++i) {
                Expansion expansion3 = expSequence.getUnitAt(i);
                if (expansion3 instanceof ExpLookahead && ((ExpLookahead)expansion3).isExplicit()) {
                    return false;
                }
                if (this._javaCodeCheck(expansion3)) {
                    return true;
                }
                if (Semanticize.emptyExpansionExists(expansion3)) continue;
                return false;
            }
            return false;
        }
        if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            return this._javaCodeCheck(expOneOrMore.getExpansion());
        }
        if (expansion instanceof ExpZeroOrMore) {
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            return this._javaCodeCheck(expZeroOrMore.getExpansion());
        }
        if (expansion instanceof ExpZeroOrOne) {
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            return this._javaCodeCheck(expZeroOrOne.getExpansion());
        }
        if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            return this._javaCodeCheck(expTryBlock.m_exp);
        }
        return false;
    }

    private void _genFirstSet(Expansion expansion) {
        if (expansion instanceof AbstractExpRegularExpression) {
            this.m_firstSet[((AbstractExpRegularExpression)expansion).getOrdinal()] = true;
        } else if (expansion instanceof ExpNonTerminal) {
            if (!(((ExpNonTerminal)expansion).getProd() instanceof AbstractCodeProduction)) {
                this._genFirstSet(((ExpNonTerminal)expansion).getProd().getExpansion());
            }
        } else if (expansion instanceof ExpChoice) {
            ExpChoice expChoice = (ExpChoice)expansion;
            for (Expansion expansion2 : expChoice.getChoices()) {
                this._genFirstSet(expansion2);
            }
        } else if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            Expansion expansion3 = expSequence.getUnitAt(0);
            if (expansion3 instanceof ExpLookahead && ((ExpLookahead)expansion3).getActionTokens().isNotEmpty()) {
                this.m_bJJ2LA = true;
            }
            for (int i = 0; i < expSequence.getUnitCount(); ++i) {
                Expansion expansion4 = expSequence.getUnitAt(i);
                if (expansion4 instanceof ExpNonTerminal && ((ExpNonTerminal)expansion4).getProd() instanceof AbstractCodeProduction) {
                    if (i > 0 && expSequence.getUnitAt(i - 1) instanceof ExpLookahead) {
                        ExpLookahead expLookahead = (ExpLookahead)expSequence.getUnitAt(i - 1);
                        this._genFirstSet(expLookahead.getLaExpansion());
                    }
                } else {
                    this._genFirstSet(expSequence.getUnitAt(i));
                }
                if (Semanticize.emptyExpansionExists(expSequence.getUnitAt(i))) {
                    continue;
                }
                break;
            }
        } else if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            this._genFirstSet(expOneOrMore.getExpansion());
        } else if (expansion instanceof ExpZeroOrMore) {
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            this._genFirstSet(expZeroOrMore.getExpansion());
        } else if (expansion instanceof ExpZeroOrOne) {
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            this._genFirstSet(expZeroOrOne.getExpansion());
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            this._genFirstSet(expTryBlock.m_exp);
        }
    }

    private void _dumpLookaheads(ExpLookahead[] expLookaheadArray, String[] stringArray) {
        for (int i = 0; i < expLookaheadArray.length; ++i) {
            PGPrinter.error("Lookahead: " + i);
            PGPrinter.error(expLookaheadArray[i].dump(0, new HashSet()).toString());
            PGPrinter.error("");
        }
    }

    /*
     * Unable to fully structure code
     */
    String buildLookaheadChecker(ExpLookahead[] var1_1, String[] var2_2) {
        var3_3 = EState.NOOPENSTM;
        var4_4 = 0;
        var5_5 = new boolean[JavaCCGlobals.s_tokenCount];
        var6_6 = "";
        var8_7 = null;
        var9_8 = (JavaCCGlobals.s_tokenCount - 1) / 32 + 1;
        var10_9 = null;
        var11_10 = this.m_codeGenerator.getOutputLanguage();
        for (var12_11 = 0; var12_11 < var1_1.length; ++var12_11) {
            block39: {
                block40: {
                    block38: {
                        var7_12 = var1_1[var12_11];
                        this.m_bJJ2LA = false;
                        if (var7_12.getAmount() != 0 && !Semanticize.emptyExpansionExists(var7_12.getLaExpansion()) && !this._javaCodeCheck(var7_12.getLaExpansion())) break block38;
                        if (var7_12.getActionTokens().isEmpty()) break;
                        switch (var3_3.ordinal()) {
                            case 0: {
                                var6_6 = (String)var6_6 + "\nif (";
                                ++var4_4;
                                break;
                            }
                            case 1: {
                                var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n} else if ("}, (String)var6_6);
                                break;
                            }
                            case 2: {
                                var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\ndefault:\u0001"}, (String)var6_6);
                                if (Options.isErrorReporting()) {
                                    var6_6 = (String)var6_6 + "\njj_la1[" + JavaCCGlobals.s_maskindex + "] = jj_gen;";
                                    ++JavaCCGlobals.s_maskindex;
                                }
                                JavaCCGlobals.MASK_VALS.add(var10_9);
                                var6_6 = (String)var6_6 + "\nif (";
                                ++var4_4;
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        this.m_codeGenerator.printTokenSetup((Token)var7_12.getActionTokens().getFirstOrNull());
                        for (Object var14_17 : var7_12.getActionTokens()) {
                            var8_7 = var14_17;
                            var6_6 = (String)var6_6 + this.m_codeGenerator.getStringToPrint(var8_7);
                        }
                        var6_6 = (String)var6_6 + this.m_codeGenerator.getTrailingComments(var8_7);
                        var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001", ") {\u0001"}, (String)var6_6, var2_2[var12_11]);
                        var3_3 = EState.OPENIF;
                        break block39;
                    }
                    if (var7_12.getAmount() != 1 || !var7_12.getActionTokens().isEmpty()) break block40;
                    if (this.m_firstSet == null) {
                        this.m_firstSet = new boolean[JavaCCGlobals.s_tokenCount];
                    }
                    for (var13_14 = 0; var13_14 < JavaCCGlobals.s_tokenCount; ++var13_14) {
                        this.m_firstSet[var13_14] = false;
                    }
                    this._genFirstSet(var7_12.getLaExpansion());
                    if (this.m_bJJ2LA) break block39;
                    switch (var3_3.ordinal()) {
                        case 1: {
                            var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n} else {\u0001"}, (String)var6_6);
                        }
                        case 0: {
                            var6_6 = (String)var6_6 + "\nswitch (";
                            if (!Options.isCacheTokens()) ** GOTO lbl67
                            switch (1.$SwitchMap$com$helger$pgcc$output$EOutputLanguage[var11_10.ordinal()]) {
                                case 1: {
                                    var6_6 = (String)var6_6 + "jj_nt.kind";
                                    ** GOTO lbl68
                                }
                                case 2: {
                                    var6_6 = (String)var6_6 + "jj_nt->kind";
                                    ** GOTO lbl68
                                }
                                default: {
                                    throw new UnsupportedOutputLanguageException(var11_10);
                                }
                            }
lbl67:
                            // 1 sources

                            var6_6 = (String)var6_6 + "jj_ntk == -1 ? jj_ntk_f() : jj_ntk";
lbl68:
                            // 3 sources

                            var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", ") {\u0001"}, (String)var6_6);
                            for (var13_14 = 0; var13_14 < JavaCCGlobals.s_tokenCount; ++var13_14) {
                                var5_5[var13_14] = false;
                            }
                            ++var4_4;
                            var10_9 = new int[var9_8];
                            for (var13_14 = 0; var13_14 < var9_8; ++var13_14) {
                                var10_9[var13_14] = 0;
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    for (var13_14 = 0; var13_14 < JavaCCGlobals.s_tokenCount; ++var13_14) {
                        if (!this.m_firstSet[var13_14] || var5_5[var13_14]) continue;
                        var5_5[var13_14] = true;
                        var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\ncase "}, (String)var6_6);
                        var14_18 = var13_14 / 32;
                        var15_19 = var13_14 % 32;
                        v0 = var14_18;
                        var10_9[v0] = var10_9[v0] | 1 << var15_19;
                        var16_21 = JavaCCGlobals.NAMES_OF_TOKENS.get(var13_14);
                        var6_6 = var16_21 == null ? (String)var6_6 + var13_14 : (String)var6_6 + var16_21;
                        var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", ":\u0001"}, (String)var6_6);
                    }
                    var6_6 = (String)var6_6 + "{";
                    var6_6 = (String)var6_6 + var2_2[var12_11];
                    var6_6 = (String)var6_6 + "\nbreak;\n}";
                    var3_3 = EState.OPENSWITCH;
                    break block39;
                }
                this.m_bJJ2LA = true;
            }
            if (!this.m_bJJ2LA) continue;
            switch (var3_3.ordinal()) {
                case 0: {
                    var6_6 = (String)var6_6 + "\nif (";
                    ++var4_4;
                    break;
                }
                case 1: {
                    var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n} else if ("}, (String)var6_6);
                    break;
                }
                case 2: {
                    var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\ndefault:\u0001"}, (String)var6_6);
                    if (Options.isErrorReporting()) {
                        var6_6 = (String)var6_6 + "\njj_la1[" + JavaCCGlobals.s_maskindex + "] = jj_gen;";
                        ++JavaCCGlobals.s_maskindex;
                    }
                    JavaCCGlobals.MASK_VALS.add(var10_9);
                    var6_6 = (String)var6_6 + "\nif (";
                    ++var4_4;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            var13_15 = ++JavaCCGlobals.s_jj2index;
            if (!ParseEngine.$assertionsDisabled && !var7_12.getLaExpansion().getInternalName().equals("")) {
                throw new AssertionError();
            }
            var7_12.getLaExpansion().setInternalName("_", var13_15);
            this.m_phase2list.add((Object)var7_12);
            var6_6 = (String)var6_6 + "jj_2" + var7_12.getLaExpansion().getInternalName() + "(" + var7_12.getAmount() + ")";
            if (var7_12.getActionTokens().isNotEmpty()) {
                var6_6 = (String)var6_6 + " && (";
                this.m_codeGenerator.printTokenSetup((Token)var7_12.getActionTokens().getFirstOrNull());
                var14_17 = var7_12.getActionTokens().iterator();
                while (var14_17.hasNext()) {
                    var8_7 = var15_20 = (Token)var14_17.next();
                    var6_6 = (String)var6_6 + this.m_codeGenerator.getStringToPrint(var8_7);
                }
                var6_6 = (String)var6_6 + this.m_codeGenerator.getTrailingComments(var8_7);
                var6_6 = (String)var6_6 + ")";
            }
            var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001", ") {\u0001"}, (String)var6_6, var2_2[var12_11]);
            var3_3 = EState.OPENIF;
        }
        switch (var3_3.ordinal()) {
            case 0: {
                var6_6 = (String)var6_6 + var2_2[var12_11];
                break;
            }
            case 1: {
                var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001", "\u0002\n} else {\u0001"}, (String)var6_6, var2_2[var12_11]);
                break;
            }
            case 2: {
                var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\ndefault:\u0001"}, (String)var6_6);
                if (Options.isErrorReporting()) {
                    var6_6 = (String)var6_6 + "\njj_la1[" + JavaCCGlobals.s_maskindex + "] = jj_gen;";
                    JavaCCGlobals.MASK_VALS.add(var10_9);
                    ++JavaCCGlobals.s_maskindex;
                }
                var6_6 = (String)var6_6 + var2_2[var12_11];
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (var13_16 = 0; var13_16 < var4_4; ++var13_16) {
            var6_6 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n}"}, (String)var6_6);
        }
        return var6_6;
    }

    void dumpFormattedString(String string) {
        char c = ' ';
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = c;
            c = string.charAt(i);
            if (c == '\n' && c2 == '\r') continue;
            if (c == '\n' || c == '\r') {
                if (bl) {
                    this.phase1NewLine();
                    continue;
                }
                this.m_codeGenerator.genCodeNewLine();
                continue;
            }
            if (c == '\u0001') {
                this.m_nIndentCount += 2;
                continue;
            }
            if (c == '\u0002') {
                this.m_nIndentCount -= 2;
                continue;
            }
            if (c == '\u0003') {
                bl = false;
                continue;
            }
            if (c == '\u0004') {
                bl = true;
                continue;
            }
            this.m_codeGenerator.genCode(c);
        }
    }

    private String _generateCPPMethodheader(CodeProductionCpp codeProductionCpp) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = null;
        Object object4 = codeProductionCpp.getReturnTypeTokens().iterator();
        while (object4.hasNext()) {
            object3 = object2 = object4.next();
            object = this.m_codeGenerator.getStringToPrint((Token)object3);
            stringBuilder.append(((Token)object3).toString());
            stringBuilder.append(" ");
        }
        object4 = "";
        if (object3 != null) {
            object4 = this.m_codeGenerator.getTrailingComments((Token)object3);
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append("(");
        if (codeProductionCpp.getParameterListTokens().size() != 0) {
            this.m_codeGenerator.printTokenSetup(codeProductionCpp.getParameterListTokens().get(0));
            object2 = codeProductionCpp.getParameterListTokens().iterator();
            while (object2.hasNext()) {
                object3 = object = (Token)object2.next();
                stringBuilder.append(this.m_codeGenerator.getStringToPrint((Token)object3));
            }
            stringBuilder.append(this.m_codeGenerator.getTrailingComments((Token)object3));
        }
        stringBuilder.append(")");
        String string2 = stringBuilder.toString();
        this.m_codeGenerator.generateMethodDefHeader(string, JavaCCGlobals.s_cu_name, codeProductionCpp.getLhs() + string2, stringBuilder.toString());
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private String _generateCPPMethodheader(BNFProduction bNFProduction, Token token) {
        void var12_17;
        Object string5;
        StringBuilder stringBuilder = new StringBuilder();
        Token token2 = token;
        String string = bNFProduction.getLhs();
        boolean bl = false;
        boolean bl2 = false;
        this.m_codeGenerator.printTokenSetup(token2);
        JavaCCGlobals.s_ccol = 1;
        String string2 = this.m_codeGenerator.getLeadingComments(token2);
        JavaCCGlobals.s_cline = token2.beginLine;
        JavaCCGlobals.s_ccol = token2.beginColumn;
        stringBuilder.append(token2.image);
        if (token2.kind == 84) {
            bl = true;
        }
        if (token2.kind == 128) {
            bl2 = true;
        }
        for (int i = 1; i < bNFProduction.getReturnTypeTokens().size(); ++i) {
            token2 = bNFProduction.getReturnTypeTokens().get(i);
            stringBuilder.append(this.m_codeGenerator.getStringToPrint(token2));
            if (token2.kind == 84) {
                bl = true;
            }
            if (token2.kind != 128) continue;
            bl2 = true;
        }
        String string3 = this.m_codeGenerator.getTrailingComments(token2);
        String string4 = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append("(");
        if (bNFProduction.getParameterListTokens().size() != 0) {
            this.m_codeGenerator.printTokenSetup(bNFProduction.getParameterListTokens().get(0));
            string5 = bNFProduction.getParameterListTokens().iterator();
            while (string5.hasNext()) {
                Token object2;
                token2 = object2 = (Token)string5.next();
                stringBuilder.append(this.m_codeGenerator.getStringToPrint(token2));
            }
            stringBuilder.append(this.m_codeGenerator.getTrailingComments(token2));
        }
        stringBuilder.append(")");
        string5 = stringBuilder.toString();
        this.m_codeGenerator.generateMethodDefHeader(string4, JavaCCGlobals.s_cu_name, bNFProduction.getLhs() + (String)string5, stringBuilder.toString());
        if (bl2) {
            String string6 = "NULL";
        } else if (bl) {
            String string7 = "";
        } else {
            String string8 = "0";
        }
        String string9 = "ERROR_RET_" + string;
        return "\n#if !defined " + string9 + "\n#define " + string9 + " " + (String)var12_17 + "\n#endif\n#define __ERROR_RET__ " + string9 + "\n";
    }

    private void _genStackCheck(boolean bl) {
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        if (Options.hasDepthLimit()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("if(++jj_depth > " + Options.getDepthLimit() + ") {");
                    this.m_codeGenerator.genCodeLine("  jj_consume_token(-1);");
                    this.m_codeGenerator.genCodeLine("  throw new ParseException();");
                    this.m_codeGenerator.genCodeLine("}");
                    this.m_codeGenerator.genCodeLine("try {");
                    break;
                }
                case CPP: {
                    if (!bl) {
                        this.m_codeGenerator.genCodeLine("if(jj_depth_error){ return __ERROR_RET__; }");
                    } else {
                        this.m_codeGenerator.genCodeLine("if(jj_depth_error){ return; }");
                    }
                    this.m_codeGenerator.genCodeLine("__jj_depth_inc __jj_depth_counter(this);");
                    this.m_codeGenerator.genCodeLine("if(jj_depth > " + Options.getDepthLimit() + ") {");
                    this.m_codeGenerator.genCodeLine("  jj_depth_error = true;");
                    this.m_codeGenerator.genCodeLine("  jj_consume_token(-1);");
                    this.m_codeGenerator.genCodeLine("  errorHandler->handleParseError(token, getToken(1), __FUNCTION__, this), hasError = true;");
                    if (!bl) {
                        this.m_codeGenerator.genCodeLine("  return __ERROR_RET__;");
                    } else {
                        this.m_codeGenerator.genCodeLine("  return;");
                    }
                    this.m_codeGenerator.genCodeLine("}");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
    }

    void genStackCheckEnd() {
        if (Options.hasDepthLimit()) {
            EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine(" } finally {");
                    this.m_codeGenerator.genCodeLine("   --jj_depth;");
                    this.m_codeGenerator.genCodeLine(" }");
                    break;
                }
                case CPP: {
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
    }

    void buildPhase1Routine(BNFProduction bNFProduction) {
        Iterator<List<Token>> iterator;
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        Token object2 = bNFProduction.getReturnTypeTokens().get(0);
        boolean bl = false;
        if (object2.kind == 84) {
            bl = true;
        }
        String string = null;
        switch (eOutputLanguage) {
            case JAVA: {
                this.m_codeGenerator.printTokenSetup(object2);
                JavaCCGlobals.s_ccol = 1;
                this.m_codeGenerator.printLeadingComments(object2);
                this.m_codeGenerator.genCode("  final " + (bNFProduction.getAccessMod() != null ? bNFProduction.getAccessMod() : "public") + " ");
                JavaCCGlobals.s_cline = object2.beginLine;
                JavaCCGlobals.s_ccol = object2.beginColumn;
                this.m_codeGenerator.printTokenOnly(object2);
                for (int i = 1; i < bNFProduction.getReturnTypeTokens().size(); ++i) {
                    object2 = bNFProduction.getReturnTypeTokens().get(i);
                    this.m_codeGenerator.printToken(object2);
                }
                this.m_codeGenerator.printTrailingComments(object2);
                this.m_codeGenerator.genCode(" " + bNFProduction.getLhs() + "(");
                if (bNFProduction.getParameterListTokens().size() != 0) {
                    this.m_codeGenerator.printTokenSetup(bNFProduction.getParameterListTokens().get(0));
                    Iterator<Token> iterator2 = bNFProduction.getParameterListTokens().iterator();
                    while (iterator2.hasNext()) {
                        Token object3;
                        object2 = object3 = iterator2.next();
                        this.m_codeGenerator.printToken(object2);
                    }
                    this.m_codeGenerator.printTrailingComments(object2);
                }
                this.m_codeGenerator.genCode(")");
                this.m_codeGenerator.genCode(" throws ParseException");
                for (List<Token> list : bNFProduction.getThrowsList()) {
                    this.m_codeGenerator.genCode(", ");
                    for (Token token : list) {
                        this.m_codeGenerator.genCode(token.image);
                    }
                }
                break;
            }
            case CPP: {
                string = this._generateCPPMethodheader(bNFProduction, object2);
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        this.m_codeGenerator.genCode(" {");
        switch (eOutputLanguage) {
            case JAVA: {
                break;
            }
            case CPP: {
                if (Options.booleanValue("STOP_ON_FIRST_ERROR") && string != null || Options.hasDepthLimit() && !bl) {
                    this.m_codeGenerator.genCode(string);
                    break;
                }
                string = null;
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        this._genStackCheck(bl);
        this.m_nIndentCount = 4;
        if (Options.isDebugParser()) {
            this.m_codeGenerator.genCodeNewLine();
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\");");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    JJEnter<std::function<void()>> jjenter([this]() {trace_call  (\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\"); });");
                    this.m_codeGenerator.genCodeLine("    JJExit <std::function<void()>> jjexit ([this]() {trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\"); });");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this.m_codeGenerator.genCodeLine("    try {");
            this.m_nIndentCount += 2;
        }
        if (!Options.booleanValue("IGNORE_ACTIONS") && bNFProduction.getDeclarationTokens().size() != 0) {
            this.m_codeGenerator.printTokenSetup(bNFProduction.getDeclarationTokens().get(0));
            --JavaCCGlobals.s_cline;
            iterator = bNFProduction.getDeclarationTokens().iterator();
            while (iterator.hasNext()) {
                Token token;
                object2 = token = (Token)iterator.next();
                this.m_codeGenerator.printToken(object2);
            }
            this.m_codeGenerator.printTrailingComments(object2);
        }
        iterator = this._phase1ExpansionGen(bNFProduction.getExpansion());
        this.dumpFormattedString((String)((Object)iterator));
        this.m_codeGenerator.genCodeNewLine();
        if (bNFProduction.isJumpPatched() && !bl) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    throw new IllegalStateException (\"Missing return statement in function\");");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    throw \"Missing return statement in function\";");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (Options.isDebugParser()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    } finally {");
                    this.m_codeGenerator.genCodeLine("      trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\");");
                    this.m_codeGenerator.genCodeLine("    }");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    } catch(...) { }");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (!bl) {
            switch (eOutputLanguage) {
                case JAVA: {
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("assert(false);");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (string != null) {
            this.m_codeGenerator.genCodeLine("\n#undef __ERROR_RET__\n");
        }
        this.genStackCheckEnd();
        this.m_codeGenerator.genCodeLine("}");
        this.m_codeGenerator.genCodeNewLine();
    }

    void phase1NewLine() {
        this.m_codeGenerator.genCodeNewLine();
        this.m_codeGenerator.genCode(StringHelper.getRepeated((char)' ', (int)this.m_nIndentCount));
    }

    private String _phase1ExpansionGen(Expansion expansion) {
        Object object;
        block91: {
            EOutputLanguage eOutputLanguage;
            Object object2;
            block92: {
                block90: {
                    Object object3;
                    Object object4;
                    object = "";
                    object2 = null;
                    eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
                    if (!(expansion instanceof AbstractExpRegularExpression)) break block90;
                    AbstractExpRegularExpression abstractExpRegularExpression = (AbstractExpRegularExpression)expansion;
                    object = (String)object + "\n";
                    if (!abstractExpRegularExpression.getLhsTokens().isEmpty()) {
                        this.m_codeGenerator.printTokenSetup(abstractExpRegularExpression.getLhsTokens().get(0));
                        object4 = abstractExpRegularExpression.getLhsTokens().iterator();
                        while (object4.hasNext()) {
                            object2 = object3 = (Token)object4.next();
                            object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                        }
                        object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                        object = (String)object + " = ";
                    }
                    if (abstractExpRegularExpression.getRhsToken() == null) {
                        object4 = ");";
                    } else {
                        switch (eOutputLanguage) {
                            case JAVA: {
                                object4 = ")." + abstractExpRegularExpression.getRhsToken().image + ";";
                                break;
                            }
                            case CPP: {
                                object4 = ")->" + abstractExpRegularExpression.getRhsToken().image + ";";
                                break;
                            }
                            default: {
                                throw new UnsupportedOutputLanguageException(eOutputLanguage);
                            }
                        }
                    }
                    object = abstractExpRegularExpression.hasLabel() ? (String)object + "jj_consume_token(" + abstractExpRegularExpression.getLabel() + (String)object4 : ((object3 = JavaCCGlobals.NAMES_OF_TOKENS.get(abstractExpRegularExpression.getOrdinal())) != null ? (String)object + "jj_consume_token(" + (String)object3 + (String)object4 : (String)object + "jj_consume_token(" + abstractExpRegularExpression.getOrdinal() + (String)object4);
                    switch (eOutputLanguage) {
                        case JAVA: {
                            break;
                        }
                        case CPP: {
                            if (Options.booleanValue("STOP_ON_FIRST_ERROR")) {
                                object = (String)object + "\n    { if (hasError) { return __ERROR_RET__; } }\n";
                                break;
                            }
                            break block91;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                    break block91;
                }
                if (!(expansion instanceof ExpNonTerminal)) break block92;
                ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
                object = (String)object + "\n";
                if (expNonTerminal.getLhsTokenCount() != 0) {
                    this.m_codeGenerator.printTokenSetup(expNonTerminal.getLhsTokenAt(0));
                    for (Token token : expNonTerminal.getLhsTokens()) {
                        object2 = token;
                        object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                    }
                    object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                    object = (String)object + " = ";
                }
                object = (String)object + expNonTerminal.getName() + "(";
                if (expNonTerminal.getArgumentTokenCount() != 0) {
                    this.m_codeGenerator.printTokenSetup(expNonTerminal.getArgumentTokenAt(0));
                    for (Token token : expNonTerminal.getArgumentTokens()) {
                        object2 = token;
                        object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                    }
                    object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                }
                object = (String)object + ");";
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        if (Options.booleanValue("STOP_ON_FIRST_ERROR")) {
                            object = (String)object + "\n    { if (hasError) { return __ERROR_RET__; } }\n";
                            break;
                        }
                        break block91;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                break block91;
            }
            if (expansion instanceof ExpAction) {
                ExpAction expAction = (ExpAction)expansion;
                object = (String)object + "\u0003\n";
                if (!Options.booleanValue("IGNORE_ACTIONS") && expAction.getActionTokens().size() != 0) {
                    this.m_codeGenerator.printTokenSetup((Token)expAction.getActionTokens().get(0));
                    JavaCCGlobals.s_ccol = 1;
                    for (Token token : expAction.getActionTokens()) {
                        object2 = token;
                        object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                    }
                    object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                }
                object = (String)object + "\u0004";
            } else if (expansion instanceof ExpChoice) {
                ExpChoice expChoice = (ExpChoice)expansion;
                ExpLookahead[] expLookaheadArray = new ExpLookahead[expChoice.getChoiceCount()];
                String[] stringArray = new String[expChoice.getChoiceCount() + 1];
                stringArray[expChoice.getChoiceCount()] = switch (eOutputLanguage) {
                    case EOutputLanguage.JAVA -> "\njj_consume_token(-1);\nthrow new ParseException();";
                    case EOutputLanguage.CPP -> "\njj_consume_token(-1);\nerrorHandler->handleParseError(token, getToken(1), __FUNCTION__, this), hasError = true;" + (Options.booleanValue("STOP_ON_FIRST_ERROR") ? "return __ERROR_RET__;\n" : "");
                    default -> throw new UnsupportedOutputLanguageException(eOutputLanguage);
                };
                for (int i = 0; i < expChoice.getChoiceCount(); ++i) {
                    ExpSequence expSequence = (ExpSequence)expChoice.getChoiceAt(i);
                    stringArray[i] = this._phase1ExpansionGen(expSequence);
                    expLookaheadArray[i] = (ExpLookahead)expSequence.getUnitAt(0);
                }
                object = this.buildLookaheadChecker(expLookaheadArray, stringArray);
            } else if (expansion instanceof ExpSequence) {
                ExpSequence expSequence = (ExpSequence)expansion;
                for (int i = 1; i < expSequence.getUnitCount(); ++i) {
                    boolean bl = false;
                    if (!JavaCCGlobals.s_jjtreeGenerated) {
                        switch (eOutputLanguage) {
                            case JAVA: {
                                break;
                            }
                            case CPP: {
                                Expansion expansion2 = expSequence.getUnitAt(i);
                                if (expansion2 instanceof ExpAction && expansion.getParent() instanceof BNFProduction && i == expSequence.getUnitCount() - 1) break;
                                bl = true;
                                object = (String)object + "\nif (!hasError) {";
                                break;
                            }
                            default: {
                                throw new UnsupportedOutputLanguageException(eOutputLanguage);
                            }
                        }
                    }
                    object = (String)object + this._phase1ExpansionGen(expSequence.getUnitAt(i));
                    if (!bl) continue;
                    object = (String)object + "\n}";
                }
            } else if (expansion instanceof ExpOneOrMore) {
                ExpLookahead expLookahead;
                ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
                Expansion expansion3 = expOneOrMore.getExpansion();
                if (expansion3 instanceof ExpSequence) {
                    expLookahead = (ExpLookahead)((ExpSequence)expansion3).getUnitAt(0);
                } else {
                    expLookahead = new ExpLookahead();
                    expLookahead.setAmount(Options.getLookahead());
                    expLookahead.setLaExpansion(expansion3);
                }
                object = (String)object + "\n";
                int n = ++this.m_nGenSymbolIndex;
                switch (eOutputLanguage) {
                    case JAVA: {
                        object = (String)object + "label_" + n + ":\n";
                        object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "while (true) {\u0001"}, (String)object);
                        break;
                    }
                    case CPP: {
                        object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "while (!hasError) {\u0001"}, (String)object);
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                object = (String)object + this._phase1ExpansionGen(expansion3);
                ExpLookahead[] expLookaheadArray = new ExpLookahead[]{expLookahead};
                String[] stringArray = new String[2];
                stringArray[0] = "";
                switch (eOutputLanguage) {
                    case JAVA: {
                        stringArray[1] = "\nbreak label_" + n + ";";
                        break;
                    }
                    case CPP: {
                        stringArray[1] = "\ngoto end_label_" + n + ";";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                object = (String)object + this.buildLookaheadChecker(expLookaheadArray, stringArray);
                object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n}"}, (String)object);
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        object = (String)object + "\nend_label_" + n + ": ;";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            } else if (expansion instanceof ExpZeroOrMore) {
                ExpLookahead expLookahead;
                ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
                Expansion expansion4 = expZeroOrMore.getExpansion();
                if (expansion4 instanceof ExpSequence) {
                    expLookahead = (ExpLookahead)((ExpSequence)expansion4).getUnitAt(0);
                } else {
                    expLookahead = new ExpLookahead();
                    expLookahead.setAmount(Options.getLookahead());
                    expLookahead.setLaExpansion(expansion4);
                }
                object = (String)object + "\n";
                int n = ++this.m_nGenSymbolIndex;
                switch (eOutputLanguage) {
                    case JAVA: {
                        object = (String)object + "label_" + n + ":\n";
                        object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "while (true) {\u0001"}, (String)object);
                        break;
                    }
                    case CPP: {
                        object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "while (!hasError) {\u0001"}, (String)object);
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                ExpLookahead[] expLookaheadArray = new ExpLookahead[]{expLookahead};
                String[] stringArray = new String[2];
                stringArray[0] = "";
                switch (eOutputLanguage) {
                    case JAVA: {
                        stringArray[1] = "\nbreak label_" + n + ";";
                        break;
                    }
                    case CPP: {
                        stringArray[1] = "\ngoto end_label_" + n + ";";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                object = (String)object + this.buildLookaheadChecker(expLookaheadArray, stringArray);
                object = (String)object + this._phase1ExpansionGen(expansion4);
                object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n}"}, (String)object);
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        object = (String)object + "\nend_label_" + n + ": ;";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            } else if (expansion instanceof ExpZeroOrOne) {
                ExpLookahead expLookahead;
                ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
                Expansion expansion5 = expZeroOrOne.getExpansion();
                if (expansion5 instanceof ExpSequence) {
                    expLookahead = (ExpLookahead)((ExpSequence)expansion5).getUnitAt(0);
                } else {
                    expLookahead = new ExpLookahead();
                    expLookahead.setAmount(Options.getLookahead());
                    expLookahead.setLaExpansion(expansion5);
                }
                ExpLookahead[] expLookaheadArray = new ExpLookahead[]{expLookahead};
                String[] stringArray = new String[]{this._phase1ExpansionGen(expansion5), "\n;"};
                object = (String)object + this.buildLookaheadChecker(expLookaheadArray, stringArray);
            } else if (expansion instanceof ExpTryBlock) {
                ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
                Expansion expansion6 = expTryBlock.m_exp;
                object = (String)object + "\n";
                object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "try {\u0001"}, (String)object);
                object = (String)object + this._phase1ExpansionGen(expansion6);
                object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0002\n}"}, (String)object);
                for (int i = 0; i < expTryBlock.m_catchblks.size(); ++i) {
                    object = (String)object + " catch (";
                    List<Token> list = expTryBlock.m_types.get(i);
                    if (list.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(list.get(0));
                        for (Token token : list) {
                            object2 = token;
                            object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                        }
                        object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                    }
                    object = (String)object + " ";
                    object2 = expTryBlock.m_ids.get(i);
                    this.m_codeGenerator.printTokenSetup((Token)object2);
                    object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                    object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                    object = (String)object + ") {\u0003\n";
                    list = expTryBlock.m_catchblks.get(i);
                    if (list.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(list.get(0));
                        JavaCCGlobals.s_ccol = 1;
                        for (Token token : list) {
                            object2 = token;
                            object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                        }
                        object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                    }
                    object = (String)object + "\u0004\n}";
                }
                if (expTryBlock.m_finallyblk != null) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            object = (String)object + " finally {\u0003\n";
                            break;
                        }
                        case CPP: {
                            object = (String)object + " finally {\u0003\n";
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                    if (expTryBlock.m_finallyblk.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(expTryBlock.m_finallyblk.get(0));
                        JavaCCGlobals.s_ccol = 1;
                        for (Iterator<Token> iterator : expTryBlock.m_finallyblk) {
                            object2 = iterator;
                            object = (String)object + this.m_codeGenerator.getStringToPrint((Token)object2);
                        }
                        object = (String)object + this.m_codeGenerator.getTrailingComments((Token)object2);
                    }
                    object = (String)object + "\u0004\n}";
                }
            }
        }
        return object;
    }

    private void _buildPhase2Routine(ExpLookahead expLookahead) {
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        Expansion expansion = expLookahead.getLaExpansion();
        switch (eOutputLanguage) {
            case JAVA: {
                this.m_codeGenerator.genCodeLine("  private boolean jj_2" + expansion.getInternalName() + "(int xla)");
                break;
            }
            case CPP: {
                this.m_codeGenerator.genCodeLine(" inline bool jj_2" + expansion.getInternalName() + "(int xla)");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        this.m_codeGenerator.genCodeLine(" {");
        this.m_codeGenerator.genCodeLine("    jj_la = xla;");
        this.m_codeGenerator.genCodeLine("    jj_scanpos = token;");
        this.m_codeGenerator.genCodeLine("    jj_lastpos = token;");
        String string = "";
        if (Options.hasDepthLimit()) {
            string = " && !jj_depth_error";
        }
        switch (eOutputLanguage) {
            case JAVA: {
                this.m_codeGenerator.genCodeLine("    try { return (!jj_3" + expansion.getInternalName() + "()" + string + "); }");
                this.m_codeGenerator.genCodeLine("    catch(LookaheadSuccess ls) { return true; }");
                break;
            }
            case CPP: {
                this.m_codeGenerator.genCodeLine("    jj_done = false;");
                this.m_codeGenerator.genCodeLine("    return (!jj_3" + expansion.getInternalName() + "() || jj_done)" + string + ";");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (Options.isErrorReporting()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    finally { jj_save(" + (expansion.getInternalIndex() - 1) + ", xla); }");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine(" { jj_save(" + (expansion.getInternalIndex() - 1) + ", xla); }");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        this.m_codeGenerator.genCodeLine("  }");
        this.m_codeGenerator.genCodeNewLine();
        Phase3Data phase3Data = new Phase3Data(expansion, expLookahead.getAmount());
        this.m_phase3list.add((Object)phase3Data);
        this.m_phase3table.put((Object)expansion, (Object)phase3Data);
    }

    private String _genReturn(boolean bl) {
        String string;
        String string2 = string = bl ? "true" : "false";
        if (Options.isDebugLookahead() && this.m_jj3_expansion != null) {
            String string3 = "trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)this.m_jj3_expansion.getParent()).getLhs()) + "(LOOKAHEAD " + (bl ? "FAILED" : "SUCCEEDED") + ")\");";
            if (Options.isErrorReporting()) {
                string3 = "if (!jj_rescan) " + string3;
            }
            return "{ " + string3 + " return " + string + "; }";
        }
        return "return " + string + ";";
    }

    private void _generate3R(@Nonnull Expansion expansion, Phase3Data phase3Data) {
        Object object;
        Expansion expansion2 = expansion;
        if (expansion.hasNoInternalName()) {
            while (true) {
                NormalProduction normalProduction;
                if (expansion2 instanceof ExpSequence && ((ExpSequence)expansion2).getUnitCount() == 2) {
                    expansion2 = ((ExpSequence)expansion2).getUnitAt(1);
                    continue;
                }
                if (!(expansion2 instanceof ExpNonTerminal) || (normalProduction = JavaCCGlobals.PRODUCTION_TABLE.get(((ExpNonTerminal)(object = (ExpNonTerminal)expansion2)).getName())) instanceof AbstractCodeProduction) break;
                expansion2 = normalProduction.getExpansion();
            }
            if (expansion2 instanceof AbstractExpRegularExpression) {
                expansion.setInternalNameOnly("jj_scan_token(" + ((AbstractExpRegularExpression)expansion2).getOrdinal() + ")");
                return;
            }
            ++this.m_nGenSymbolIndex;
            expansion.setInternalName("R_", this.m_nGenSymbolIndex);
        }
        if ((object = (Phase3Data)this.m_phase3table.get((Object)expansion)) == null || ((Phase3Data)object).m_count < phase3Data.m_count) {
            object = new Phase3Data(expansion, phase3Data.m_count);
            this.m_phase3list.add(object);
            this.m_phase3table.put((Object)expansion, object);
        }
    }

    void setupPhase3Builds(Phase3Data phase3Data) {
        Expansion expansion = phase3Data.m_exp;
        if (!(expansion instanceof AbstractExpRegularExpression)) {
            if (expansion instanceof ExpNonTerminal) {
                ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
                NormalProduction normalProduction = JavaCCGlobals.PRODUCTION_TABLE.get(expNonTerminal.getName());
                if (!(normalProduction instanceof AbstractCodeProduction)) {
                    this._generate3R(normalProduction.getExpansion(), phase3Data);
                }
            } else if (expansion instanceof ExpChoice) {
                ExpChoice expChoice = (ExpChoice)expansion;
                for (Expansion expansion2 : expChoice.getChoices()) {
                    this._generate3R(expansion2, phase3Data);
                }
            } else if (expansion instanceof ExpSequence) {
                ExpSequence expSequence = (ExpSequence)expansion;
                int n = phase3Data.m_count;
                for (int i = 1; i < expSequence.getUnitCount(); ++i) {
                    Expansion expansion3 = expSequence.getUnitAt(i);
                    this.setupPhase3Builds(new Phase3Data(expansion3, n));
                    if ((n -= this.minimumSize(expansion3)) > 0) {
                        continue;
                    }
                    break;
                }
            } else if (expansion instanceof ExpTryBlock) {
                ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
                this.setupPhase3Builds(new Phase3Data(expTryBlock.m_exp, phase3Data.m_count));
            } else if (expansion instanceof ExpOneOrMore) {
                ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
                this._generate3R(expOneOrMore.getExpansion(), phase3Data);
            } else if (expansion instanceof ExpZeroOrMore) {
                ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
                this._generate3R(expZeroOrMore.getExpansion(), phase3Data);
            } else if (expansion instanceof ExpZeroOrOne) {
                ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
                this._generate3R(expZeroOrOne.getExpansion(), phase3Data);
            }
        }
    }

    private String _getTypeForToken() {
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                return "Token";
            }
            case CPP: {
                return "Token *";
            }
        }
        throw new UnsupportedOutputLanguageException(eOutputLanguage);
    }

    private String _genjj_3Call(Expansion expansion) {
        String string = expansion.getInternalName();
        if (string.startsWith("jj_scan_token")) {
            return string;
        }
        return "jj_3" + string + "()";
    }

    void buildPhase3Routine(Phase3Data phase3Data, boolean bl) {
        Expansion expansion = phase3Data.m_exp;
        Token token = null;
        if (expansion.getInternalName().startsWith("jj_scan_token")) {
            return;
        }
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        if (!bl) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " jj_3" + expansion.getInternalName() + "()");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine(" inline bool jj_3" + expansion.getInternalName() + "()");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this.m_codeGenerator.genCodeLine(" {");
            switch (eOutputLanguage) {
                case JAVA: {
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    if (jj_done) return true;");
                    if (!Options.hasDepthLimit()) break;
                    this.m_codeGenerator.genCodeLine("#define __ERROR_RET__ true");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this._genStackCheck(false);
            this.m_xsp_declared = false;
            if (Options.isDebugLookahead() && expansion.getParent() instanceof NormalProduction) {
                this.m_codeGenerator.genCode("    ");
                if (Options.isErrorReporting()) {
                    this.m_codeGenerator.genCode("if (!jj_rescan) ");
                }
                this.m_codeGenerator.genCodeLine("trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)expansion.getParent()).getLhs()) + "(LOOKING AHEAD...)\");");
                this.m_jj3_expansion = expansion;
            } else {
                this.m_jj3_expansion = null;
            }
        }
        if (expansion instanceof AbstractExpRegularExpression) {
            AbstractExpRegularExpression abstractExpRegularExpression = (AbstractExpRegularExpression)expansion;
            if (abstractExpRegularExpression.hasLabel()) {
                this.m_codeGenerator.genCodeLine("    if (jj_scan_token(" + abstractExpRegularExpression.getLabel() + ")) " + this._genReturn(true));
            } else {
                String string = JavaCCGlobals.NAMES_OF_TOKENS.get(abstractExpRegularExpression.getOrdinal());
                if (string != null) {
                    this.m_codeGenerator.genCodeLine("    if (jj_scan_token(" + string + ")) " + this._genReturn(true));
                } else {
                    this.m_codeGenerator.genCodeLine("    if (jj_scan_token(" + abstractExpRegularExpression.getOrdinal() + ")) " + this._genReturn(true));
                }
            }
        } else if (expansion instanceof ExpNonTerminal) {
            ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
            NormalProduction normalProduction = JavaCCGlobals.PRODUCTION_TABLE.get(expNonTerminal.getName());
            if (normalProduction instanceof AbstractCodeProduction) {
                this.m_codeGenerator.genCodeLine("    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; " + this._genReturn(false) + "}");
            } else {
                Expansion expansion2 = normalProduction.getExpansion();
                this.m_codeGenerator.genCodeLine("    if (" + this._genjj_3Call(expansion2) + ") " + this._genReturn(true));
            }
        } else if (expansion instanceof ExpChoice) {
            int n;
            ExpChoice expChoice = (ExpChoice)expansion;
            if (expChoice.getChoiceCount() != 1) {
                if (!this.m_xsp_declared) {
                    this.m_xsp_declared = true;
                    this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
                }
                this.m_codeGenerator.genCodeLine("    xsp = jj_scanpos;");
            }
            for (n = 0; n < expChoice.getChoiceCount(); ++n) {
                ExpSequence expSequence = (ExpSequence)expChoice.getChoiceAt(n);
                ExpLookahead expLookahead = (ExpLookahead)expSequence.getUnitAt(0);
                if (expLookahead.getActionTokens().isNotEmpty()) {
                    JavaCCGlobals.setLookAheadNeeded(true);
                    this.m_codeGenerator.genCodeLine("    jj_lookingAhead = true;");
                    this.m_codeGenerator.genCode("    jj_semLA = ");
                    this.m_codeGenerator.printTokenSetup((Token)expLookahead.getActionTokens().getFirstOrNull());
                    Iterator iterator = expLookahead.getActionTokens().iterator();
                    while (iterator.hasNext()) {
                        Token token2;
                        token = token2 = (Token)iterator.next();
                        this.m_codeGenerator.printToken(token);
                    }
                    this.m_codeGenerator.printTrailingComments(token);
                    this.m_codeGenerator.genCodeLine(";");
                    this.m_codeGenerator.genCodeLine("    jj_lookingAhead = false;");
                }
                this.m_codeGenerator.genCode("    if (");
                if (expLookahead.getActionTokens().isNotEmpty()) {
                    this.m_codeGenerator.genCode("!jj_semLA || ");
                }
                if (n != expChoice.getChoiceCount() - 1) {
                    this.m_codeGenerator.genCodeLine(this._genjj_3Call(expSequence) + ") {");
                    this.m_codeGenerator.genCodeLine("    jj_scanpos = xsp;");
                    continue;
                }
                this.m_codeGenerator.genCodeLine(this._genjj_3Call(expSequence) + ") " + this._genReturn(true));
            }
            for (n = 1; n < expChoice.getChoiceCount(); ++n) {
                this.m_codeGenerator.genCodeLine("    }");
            }
        } else if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            int n = phase3Data.m_count;
            for (int i = 1; i < expSequence.getUnitCount(); ++i) {
                Expansion expansion3 = expSequence.getUnitAt(i);
                this.buildPhase3Routine(new Phase3Data(expansion3, n), true);
                if ((n -= this.minimumSize(expansion3)) > 0) {
                    continue;
                }
                break;
            }
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            this.buildPhase3Routine(new Phase3Data(expTryBlock.m_exp, phase3Data.m_count), true);
        } else if (expansion instanceof ExpOneOrMore) {
            if (!this.m_xsp_declared) {
                this.m_xsp_declared = true;
                this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
            }
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            Expansion expansion4 = expOneOrMore.getExpansion();
            this.m_codeGenerator.genCodeLine("    if (" + this._genjj_3Call(expansion4) + ") " + this._genReturn(true));
            this.m_codeGenerator.genCodeLine("    while (true) {");
            this.m_codeGenerator.genCodeLine("      xsp = jj_scanpos;");
            this.m_codeGenerator.genCodeLine("      if (" + this._genjj_3Call(expansion4) + ") { jj_scanpos = xsp; break; }");
            this.m_codeGenerator.genCodeLine("    }");
        } else if (expansion instanceof ExpZeroOrMore) {
            if (!this.m_xsp_declared) {
                this.m_xsp_declared = true;
                this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
            }
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            Expansion expansion5 = expZeroOrMore.getExpansion();
            this.m_codeGenerator.genCodeLine("    while (true) {");
            this.m_codeGenerator.genCodeLine("      xsp = jj_scanpos;");
            this.m_codeGenerator.genCodeLine("      if (" + this._genjj_3Call(expansion5) + ") { jj_scanpos = xsp; break; }");
            this.m_codeGenerator.genCodeLine("    }");
        } else if (expansion instanceof ExpZeroOrOne) {
            if (!this.m_xsp_declared) {
                this.m_xsp_declared = true;
                this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
            }
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            Expansion expansion6 = expZeroOrOne.getExpansion();
            this.m_codeGenerator.genCodeLine("    xsp = jj_scanpos;");
            this.m_codeGenerator.genCodeLine("    if (" + this._genjj_3Call(expansion6) + ") jj_scanpos = xsp;");
        }
        if (!bl) {
            this.m_codeGenerator.genCodeLine("    " + this._genReturn(false));
            this.genStackCheckEnd();
            switch (eOutputLanguage) {
                case JAVA: {
                    break;
                }
                case CPP: {
                    if (!Options.hasDepthLimit()) break;
                    this.m_codeGenerator.genCodeLine("#undef __ERROR_RET__");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this.m_codeGenerator.genCodeLine("  }");
            this.m_codeGenerator.genCodeNewLine();
        }
    }

    int minimumSize(Expansion expansion) {
        return this.minimumSize(expansion, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int minimumSize(Expansion expansion, int n) {
        if (expansion.isInMinimumSize()) {
            return Integer.MAX_VALUE;
        }
        expansion.setInMinimumSize(true);
        try {
            if (expansion instanceof AbstractExpRegularExpression) {
                int n2 = 1;
                return n2;
            }
            if (expansion instanceof ExpNonTerminal) {
                ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
                NormalProduction normalProduction = JavaCCGlobals.PRODUCTION_TABLE.get(expNonTerminal.getName());
                if (normalProduction instanceof AbstractCodeProduction) {
                    int n3 = Integer.MAX_VALUE;
                    return n3;
                }
                Expansion expansion2 = normalProduction.getExpansion();
                int n4 = this.minimumSize(expansion2);
                return n4;
            }
            if (expansion instanceof ExpChoice) {
                int n5;
                int n6 = n;
                ExpChoice expChoice = (ExpChoice)expansion;
                for (n5 = 0; n6 > 1 && n5 < expChoice.getChoiceCount(); ++n5) {
                    Expansion expansion3 = expChoice.getChoiceAt(n5);
                    int n7 = this.minimumSize(expansion3, n6);
                    if (n6 <= n7) continue;
                    n6 = n7;
                }
                n5 = n6;
                return n5;
            }
            if (expansion instanceof ExpSequence) {
                int n8;
                int n9 = 0;
                ExpSequence expSequence = (ExpSequence)expansion;
                for (n8 = 1; n8 < expSequence.getUnitCount(); ++n8) {
                    Expansion expansion4 = expSequence.getUnitAt(n8);
                    int n10 = this.minimumSize(expansion4);
                    if (n9 == Integer.MAX_VALUE || n10 == Integer.MAX_VALUE) {
                        n9 = Integer.MAX_VALUE;
                        continue;
                    }
                    if ((n9 += n10) > n) break;
                }
                n8 = n9;
                return n8;
            }
            if (expansion instanceof ExpTryBlock) {
                ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
                int n11 = this.minimumSize(expTryBlock.m_exp);
                return n11;
            }
            if (expansion instanceof ExpOneOrMore) {
                ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
                int n12 = this.minimumSize(expOneOrMore.getExpansion());
                return n12;
            }
            if (expansion instanceof ExpZeroOrMore) {
                int n13 = 0;
                return n13;
            }
            if (expansion instanceof ExpZeroOrOne) {
                int n14 = 0;
                return n14;
            }
            if (expansion instanceof ExpLookahead) {
                int n15 = 0;
                return n15;
            }
            if (expansion instanceof ExpAction) {
                int n16 = 0;
                return n16;
            }
            PGPrinter.warn("Found unsupported Expansion - " + String.valueOf(expansion));
            int n17 = 0;
            return n17;
        }
        finally {
            expansion.setInMinimumSize(false);
        }
    }

    void build(CodeGenerator codeGenerator) {
        this.m_codeGenerator = codeGenerator;
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        for (NormalProduction normalProduction : JavaCCGlobals.BNF_PRODUCTIONS) {
            Object object;
            if (normalProduction instanceof CodeProductionCpp) {
                if (!eOutputLanguage.isJava()) {
                    JavaCCErrors.semantic_error("Cannot use JAVACODE productions with non-Java output.");
                    continue;
                }
                object = (CodeProductionCpp)normalProduction;
                this._generateCPPMethodheader((CodeProductionCpp)object);
                codeGenerator.genCodeLine(" {");
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeNewLine();
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("    trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object).getLhs()) + "\");");
                            codeGenerator.genCodeLine("    try {");
                            break;
                        }
                        case CPP: {
                            codeGenerator.genCodeLine("    JJEnter<std::function<void()>> jjenter([this]() {trace_call  (\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object).getLhs()) + "\"); });");
                            codeGenerator.genCodeLine("    JJExit <std::function<void()>> jjexit ([this]() {trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object).getLhs()) + "\"); });");
                            codeGenerator.genCodeLine("    try {");
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                if (((AbstractCodeProduction)object).getCodeTokens().size() != 0) {
                    codeGenerator.printTokenSetup((Token)((AbstractCodeProduction)object).getCodeTokens().get(0));
                    --JavaCCGlobals.s_cline;
                    codeGenerator.printTokenList((List<Token>)((AbstractCodeProduction)object).getCodeTokens());
                }
                codeGenerator.genCodeNewLine();
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeLine("    } catch(...) { }");
                }
                codeGenerator.genCodeLine("  }");
                codeGenerator.genCodeNewLine();
                continue;
            }
            if (normalProduction instanceof CodeProductionJava) {
                if (!eOutputLanguage.isJava()) {
                    JavaCCErrors.semantic_error("Cannot use JAVACODE productions with non-Java output.");
                    continue;
                }
                object = (CodeProductionJava)normalProduction;
                Token token = ((NormalProduction)object).getReturnTypeTokens().get(0);
                codeGenerator.printTokenSetup(token);
                JavaCCGlobals.s_ccol = 1;
                codeGenerator.printLeadingComments(token);
                codeGenerator.genCode("  " + (String)(normalProduction.getAccessMod() != null ? normalProduction.getAccessMod() + " " : ""));
                JavaCCGlobals.s_cline = token.beginLine;
                JavaCCGlobals.s_ccol = token.beginColumn;
                codeGenerator.printTokenOnly(token);
                for (int i = 1; i < ((NormalProduction)object).getReturnTypeTokens().size(); ++i) {
                    token = ((NormalProduction)object).getReturnTypeTokens().get(i);
                    codeGenerator.printToken(token);
                }
                codeGenerator.printTrailingComments(token);
                codeGenerator.genCode(" " + ((NormalProduction)object).getLhs() + "(");
                if (((NormalProduction)object).getParameterListTokens().size() != 0) {
                    codeGenerator.printTokenSetup(((NormalProduction)object).getParameterListTokens().get(0));
                    Iterator<Token> iterator = ((NormalProduction)object).getParameterListTokens().iterator();
                    while (iterator.hasNext()) {
                        Token token2;
                        token = token2 = iterator.next();
                        codeGenerator.printToken(token);
                    }
                    codeGenerator.printTrailingComments(token);
                }
                codeGenerator.genCode(")");
                switch (eOutputLanguage) {
                    case JAVA: {
                        codeGenerator.genCode(" throws ParseException");
                        break;
                    }
                    case CPP: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                for (List<Token> list : ((NormalProduction)object).getThrowsList()) {
                    codeGenerator.genCode(", ");
                    Iterator<Token> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Token token3;
                        token = token3 = iterator.next();
                        codeGenerator.genCode(token.image);
                    }
                }
                codeGenerator.genCode(" {");
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeNewLine();
                    codeGenerator.genCodeLine("    trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object).getLhs()) + "\");");
                    codeGenerator.genCode("    try {");
                }
                if (((AbstractCodeProduction)object).getCodeTokens().size() != 0) {
                    codeGenerator.printTokenSetup((Token)((AbstractCodeProduction)object).getCodeTokens().get(0));
                    --JavaCCGlobals.s_cline;
                    codeGenerator.printTokenList((List<Token>)((AbstractCodeProduction)object).getCodeTokens());
                }
                codeGenerator.genCodeNewLine();
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeLine("    } finally {");
                    codeGenerator.genCodeLine("      trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object).getLhs()) + "\");");
                    codeGenerator.genCodeLine("    }");
                }
                codeGenerator.genCodeLine("  }");
                codeGenerator.genCodeNewLine();
                continue;
            }
            this.buildPhase1Routine((BNFProduction)normalProduction);
        }
        codeGenerator.switchToIncludeFile();
        for (ExpLookahead expLookahead : this.m_phase2list) {
            this._buildPhase2Routine(expLookahead);
        }
        int n = 0;
        while (n < this.m_phase3list.size()) {
            while (n < this.m_phase3list.size()) {
                this.setupPhase3Builds((Phase3Data)this.m_phase3list.get(n));
                ++n;
            }
        }
        for (Object object : this.m_phase3table.values()) {
            this.buildPhase3Routine((Phase3Data)object, false);
        }
        codeGenerator.switchToMainFile();
    }

    public void reInit() {
        this.m_nGenSymbolIndex = 0;
        this.m_nIndentCount = 0;
        this.m_bJJ2LA = false;
        this.m_phase2list.clear();
        this.m_phase3list.clear();
        this.m_phase3table.clear();
        this.m_firstSet = null;
        this.m_xsp_declared = false;
        this.m_jj3_expansion = null;
    }

    void buildPhase3TableRec(Phase3Data phase3Data) {
        Expansion expansion = phase3Data.m_exp;
        if (expansion instanceof AbstractExpRegularExpression) {
            AbstractExpRegularExpression abstractExpRegularExpression = (AbstractExpRegularExpression)expansion;
            PGPrinter.info("TOKEN, " + abstractExpRegularExpression.getOrdinal());
        } else if (expansion instanceof ExpNonTerminal) {
            ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
            NormalProduction normalProduction = JavaCCGlobals.PRODUCTION_TABLE.get(expNonTerminal.getName());
            if (normalProduction instanceof AbstractCodeProduction) {
                PGPrinter.info("JAVACODE_PROD, true");
            } else {
                Expansion expansion2 = normalProduction.getExpansion();
                PGPrinter.info("PRODUCTION, " + expansion2.getInternalIndex());
            }
        } else if (expansion instanceof ExpChoice) {
            ExpChoice expChoice = (ExpChoice)expansion;
            PGPrinter.info("CHOICE, ");
            for (int i = 0; i < expChoice.getChoiceCount(); ++i) {
                ExpSequence expSequence;
                ExpLookahead expLookahead;
                if (i > 0) {
                    PGPrinter.info("\n|");
                }
                if ((expLookahead = (ExpLookahead)(expSequence = (ExpSequence)expChoice.getChoiceAt(i)).getUnitAt(0)).getActionTokens().isNotEmpty()) {
                    PGPrinter.info("SEMANTIC,");
                    continue;
                }
                PGPrinter.info("<start recurse>");
                this.buildPhase3TableRec(new Phase3Data(expSequence, phase3Data.m_count));
                PGPrinter.info("<end recurse>");
            }
            PGPrinter.info();
        } else if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            int n = phase3Data.m_count;
            if (expSequence.getUnitCount() > 2) {
                PGPrinter.info("SEQ, " + n);
                for (int i = 1; i < expSequence.getUnitCount(); ++i) {
                    Expansion expansion3 = expSequence.getUnitAt(i);
                    this.buildPhase3TableRec(new Phase3Data(expansion3, n));
                    if ((n -= this.minimumSize(expansion3)) > 0) {
                        continue;
                    }
                    break;
                }
            } else {
                NormalProduction normalProduction;
                Expansion expansion4 = expSequence.getUnitAt(1);
                while (expansion4 instanceof ExpNonTerminal && !((normalProduction = JavaCCGlobals.PRODUCTION_TABLE.get(((ExpNonTerminal)expansion4).getName())) instanceof AbstractCodeProduction)) {
                    expansion4 = normalProduction.getExpansion();
                }
                this.buildPhase3TableRec(new Phase3Data(expansion4, n));
            }
            PGPrinter.info();
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            this.buildPhase3TableRec(new Phase3Data(expTryBlock.m_exp, phase3Data.m_count));
        } else if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            PGPrinter.info("SEQ PROD " + expOneOrMore.getExpansion().getInternalIndex());
            PGPrinter.info("ZEROORMORE " + expOneOrMore.getExpansion().getInternalIndex());
        } else if (expansion instanceof ExpZeroOrMore) {
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            PGPrinter.info("ZEROORMORE, " + expZeroOrMore.getExpansion().getInternalIndex());
        } else if (expansion instanceof ExpZeroOrOne) {
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            PGPrinter.info("ZERORONE, " + expZeroOrOne.getExpansion().getInternalIndex());
        } else assert (false);
    }

    static enum EState {
        NOOPENSTM,
        OPENIF,
        OPENSWITCH;

    }
}

