/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser.exp;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.exp.Expansion;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExpChoice
extends Expansion {
    private final List<Expansion> m_choices = new ArrayList<Expansion>();

    public ExpChoice() {
    }

    public ExpChoice(Token token) {
        this.setLine(token.beginLine);
        this.setColumn(token.beginColumn);
    }

    public ExpChoice(Expansion expansion) {
        this.setLine(expansion.getLine());
        this.setColumn(expansion.getColumn());
        this.m_choices.add(expansion);
    }

    @Nonnull
    public final Iterable<Expansion> getChoices() {
        return this.m_choices;
    }

    @Nonnegative
    public final int getChoiceCount() {
        return this.m_choices.size();
    }

    @Nonnull
    public final Expansion getChoiceAt(int n) {
        return this.m_choices.get(n);
    }

    public final void addChoice(@Nonnull Expansion expansion) {
        ValueEnforcer.notNull((Object)expansion, (String)"Expansion");
        this.m_choices.add(expansion);
    }

    @Override
    public StringBuilder dump(int n, Set<? super Expansion> set) {
        StringBuilder stringBuilder = super.dump(n, set);
        if (set.add(this)) {
            for (Expansion expansion : this.getChoices()) {
                stringBuilder.append(EOL).append((CharSequence)expansion.dump(n + 1, set));
            }
        }
        return stringBuilder;
    }
}

