/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser.exp;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.exp.ExpLookahead;
import com.helger.pgcc.parser.exp.Expansion;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExpSequence
extends Expansion {
    private final List<Expansion> m_units = new ArrayList<Expansion>();

    public ExpSequence() {
    }

    public ExpSequence(Token token, ExpLookahead expLookahead) {
        this.setLine(token.beginLine);
        this.setColumn(token.beginColumn);
        this.m_units.add(expLookahead);
    }

    @Nonnull
    public final Iterable<Expansion> getUnits() {
        return this.m_units;
    }

    @Nonnegative
    public final int getUnitCount() {
        return this.m_units.size();
    }

    @Nonnull
    public final Expansion getUnitAt(int n) {
        return this.m_units.get(n);
    }

    public final void addUnit(Expansion expansion) {
        ValueEnforcer.notNull((Object)expansion, (String)"Obj");
        this.m_units.add(expansion);
    }

    public final void addUnit(int n, Expansion expansion) {
        ValueEnforcer.notNull((Object)expansion, (String)"Obj");
        this.m_units.add(n, expansion);
    }

    public final void setUnit(int n, Expansion expansion) {
        ValueEnforcer.notNull((Object)expansion, (String)"Obj");
        this.m_units.set(n, expansion);
    }

    @Override
    public StringBuilder dump(int n, Set<? super Expansion> set) {
        if (!set.add(this)) {
            return super.dump(0, set).insert(0, '[').append(']').insert(0, ExpSequence.dumpPrefix(n));
        }
        StringBuilder stringBuilder = super.dump(n, set);
        for (Expansion expansion : this.m_units) {
            stringBuilder.append(EOL).append((CharSequence)expansion.dump(n + 1, set));
        }
        return stringBuilder;
    }
}

