/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.bdxr;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.peppol.bdxr.ExtensionType;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Immutable
public final class BDXRExtensionConverter {
    public static final String JSON_ID = "ID";
    public static final String JSON_NAME = "Name";
    public static final String JSON_AGENCY_ID = "AgencyID";
    public static final String JSON_AGENCY_NAME = "AgencyName";
    public static final String JSON_AGENCY_URI = "AgencyURI";
    public static final String JSON_VERSION_ID = "VersionID";
    public static final String JSON_URI = "URI";
    public static final String JSON_REASON_CODE = "ReasonCode";
    public static final String JSON_REASON = "Reason";
    public static final String JSON_ANY = "Any";
    private static final XMLWriterSettings s_aXWS = new XMLWriterSettings().setIndent(EXMLSerializeIndent.NONE);
    private static final JsonWriterSettings s_aJWS = new JsonWriterSettings().setIndentEnabled(false).setWriteNewlineAtEnd(false);
    private static final BDXRExtensionConverter s_aInstance = new BDXRExtensionConverter();

    private BDXRExtensionConverter() {
    }

    @Nullable
    public static IJsonObject convertToJson(@Nullable ExtensionType extensionType) {
        if (extensionType != null && extensionType.getAny() != null) {
            Object object = extensionType.getAny();
            if (object instanceof Element) {
                object = XMLWriter.getNodeAsString((Node)((Element)object), (IXMLWriterSettings)s_aXWS);
            }
            JsonObject jsonObject = new JsonObject();
            if (extensionType.getExtensionID() != null) {
                jsonObject.add(JSON_ID, (Object)extensionType.getExtensionID());
            }
            if (extensionType.getExtensionName() != null) {
                jsonObject.add(JSON_NAME, (Object)extensionType.getExtensionName());
            }
            if (extensionType.getExtensionAgencyID() != null) {
                jsonObject.add(JSON_AGENCY_ID, (Object)extensionType.getExtensionAgencyID());
            }
            if (extensionType.getExtensionAgencyName() != null) {
                jsonObject.add(JSON_AGENCY_NAME, (Object)extensionType.getExtensionAgencyName());
            }
            if (extensionType.getExtensionAgencyURI() != null) {
                jsonObject.add(JSON_AGENCY_URI, (Object)extensionType.getExtensionAgencyURI());
            }
            if (extensionType.getExtensionVersionID() != null) {
                jsonObject.add(JSON_VERSION_ID, (Object)extensionType.getExtensionVersionID());
            }
            if (extensionType.getExtensionURI() != null) {
                jsonObject.add(JSON_URI, (Object)extensionType.getExtensionURI());
            }
            if (extensionType.getExtensionReasonCode() != null) {
                jsonObject.add(JSON_REASON_CODE, (Object)extensionType.getExtensionReasonCode());
            }
            if (extensionType.getExtensionReason() != null) {
                jsonObject.add(JSON_REASON, (Object)extensionType.getExtensionReason());
            }
            if (object != null) {
                jsonObject.add(JSON_ANY, object);
            }
            return jsonObject;
        }
        return null;
    }

    @Nullable
    public static IJsonArray convertToJson(@Nullable List<ExtensionType> list) {
        if (CollectionHelper.isNotEmpty(list)) {
            JsonArray jsonArray = new JsonArray();
            for (ExtensionType extensionType : list) {
                IJsonObject iJsonObject = BDXRExtensionConverter.convertToJson(extensionType);
                if (iJsonObject == null) continue;
                jsonArray.add((IJson)iJsonObject);
            }
            return jsonArray;
        }
        return null;
    }

    @Nullable
    public static String convertToString(@Nullable List<ExtensionType> list) {
        IJsonArray iJsonArray = BDXRExtensionConverter.convertToJson(list);
        return iJsonArray == null ? null : iJsonArray.getAsJsonString((IJsonWriterSettings)s_aJWS);
    }

    @Nullable
    public static ICommonsList<ExtensionType> convertXMLToSingleExtension(@Nullable String string) {
        Object object;
        Element element = null;
        if (StringHelper.hasText((String)string)) {
            try {
                object = DOMReader.readXMLDOM((String)string);
                if (object != null) {
                    element = object.getDocumentElement();
                }
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        if (element == null) {
            return null;
        }
        object = new ExtensionType();
        ((ExtensionType)object).setAny(element);
        return new CommonsArrayList(object);
    }

    @Nullable
    public static ICommonsList<ExtensionType> convert(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            IJson iJson = JsonReader.readFromString((String)string);
            if (iJson == null || !iJson.isArray()) {
                throw new IllegalArgumentException("Error in parsing extension JSON '" + string + "'");
            }
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            iJson.getAsArray().forEach(arg_0 -> BDXRExtensionConverter.lambda$convert$0((ICommonsList)commonsArrayList, arg_0));
            return commonsArrayList;
        }
        return null;
    }

    @Nullable
    public static ICommonsList<ExtensionType> convertOrNull(@Nullable String string) {
        try {
            return BDXRExtensionConverter.convert(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$convert$0(ICommonsList iCommonsList, IJson iJson) {
        IJsonObject iJsonObject = iJson.getAsObject();
        ExtensionType extensionType = new ExtensionType();
        extensionType.setExtensionID(iJsonObject.getAsString((Object)JSON_ID));
        extensionType.setExtensionName(iJsonObject.getAsString((Object)JSON_NAME));
        extensionType.setExtensionAgencyID(iJsonObject.getAsString((Object)JSON_AGENCY_ID));
        extensionType.setExtensionAgencyName(iJsonObject.getAsString((Object)JSON_AGENCY_NAME));
        extensionType.setExtensionAgencyURI(iJsonObject.getAsString((Object)JSON_AGENCY_URI));
        extensionType.setExtensionVersionID(iJsonObject.getAsString((Object)JSON_VERSION_ID));
        extensionType.setExtensionURI(iJsonObject.getAsString((Object)JSON_URI));
        extensionType.setExtensionReasonCode(iJsonObject.getAsString((Object)JSON_REASON_CODE));
        extensionType.setExtensionReason(iJsonObject.getAsString((Object)JSON_REASON));
        String string = iJsonObject.getAsString((Object)JSON_ANY);
        if (StringHelper.hasText((String)string)) {
            try {
                Document document = DOMReader.readXMLDOM((String)string);
                if (document != null) {
                    extensionType.setAny(document.getDocumentElement());
                }
            }
            catch (SAXException sAXException) {
                throw new IllegalStateException("Failed to parse any as XML: " + string, sAXException);
            }
        }
        iCommonsList.add((Object)extensionType);
    }
}

