/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.bdxr;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.bdxr.ExtensionType;
import com.helger.peppol.xsd.Adapter1;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EndpointType", propOrder={"endpointURI", "requireBusinessLevelSignature", "minimumAuthenticationLevel", "serviceActivationDate", "serviceExpirationDate", "certificate", "serviceDescription", "technicalContactUrl", "technicalInformationUrl", "extension"})
@CodingStyleguideUnaware
public class EndpointType
implements Serializable,
Cloneable {
    @XmlElement(name="EndpointURI", required=true)
    @XmlSchemaType(name="anyURI")
    private String endpointURI;
    @XmlElement(name="RequireBusinessLevelSignature", defaultValue="false")
    private Boolean requireBusinessLevelSignature;
    @XmlElement(name="MinimumAuthenticationLevel")
    private String minimumAuthenticationLevel;
    @XmlElement(name="ServiceActivationDate", type=String.class)
    @XmlJavaTypeAdapter(value=Adapter1.class)
    @XmlSchemaType(name="dateTime")
    private LocalDateTime serviceActivationDate;
    @XmlElement(name="ServiceExpirationDate", type=String.class)
    @XmlJavaTypeAdapter(value=Adapter1.class)
    @XmlSchemaType(name="dateTime")
    private LocalDateTime serviceExpirationDate;
    @XmlElement(name="Certificate", required=true)
    private byte[] certificate;
    @XmlElement(name="ServiceDescription", required=true)
    private String serviceDescription;
    @XmlElement(name="TechnicalContactUrl", required=true)
    @XmlSchemaType(name="anyURI")
    private String technicalContactUrl;
    @XmlElement(name="TechnicalInformationUrl")
    @XmlSchemaType(name="anyURI")
    private String technicalInformationUrl;
    @XmlElement(name="Extension")
    private List<ExtensionType> extension;
    @XmlAttribute(name="transportProfile", required=true)
    private String transportProfile;

    @Nullable
    public String getEndpointURI() {
        return this.endpointURI;
    }

    public void setEndpointURI(@Nullable String string) {
        this.endpointURI = string;
    }

    public Boolean isRequireBusinessLevelSignature() {
        return this.requireBusinessLevelSignature;
    }

    public void setRequireBusinessLevelSignature(@Nullable Boolean bl) {
        this.requireBusinessLevelSignature = bl;
    }

    @Nullable
    public String getMinimumAuthenticationLevel() {
        return this.minimumAuthenticationLevel;
    }

    public void setMinimumAuthenticationLevel(@Nullable String string) {
        this.minimumAuthenticationLevel = string;
    }

    @Nullable
    public LocalDateTime getServiceActivationDate() {
        return this.serviceActivationDate;
    }

    public void setServiceActivationDate(@Nullable LocalDateTime localDateTime) {
        this.serviceActivationDate = localDateTime;
    }

    @Nullable
    public LocalDateTime getServiceExpirationDate() {
        return this.serviceExpirationDate;
    }

    public void setServiceExpirationDate(@Nullable LocalDateTime localDateTime) {
        this.serviceExpirationDate = localDateTime;
    }

    @Nullable
    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(@Nullable byte[] byArray) {
        this.certificate = byArray;
    }

    @Nullable
    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(@Nullable String string) {
        this.serviceDescription = string;
    }

    @Nullable
    public String getTechnicalContactUrl() {
        return this.technicalContactUrl;
    }

    public void setTechnicalContactUrl(@Nullable String string) {
        this.technicalContactUrl = string;
    }

    @Nullable
    public String getTechnicalInformationUrl() {
        return this.technicalInformationUrl;
    }

    public void setTechnicalInformationUrl(@Nullable String string) {
        this.technicalInformationUrl = string;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ExtensionType> getExtension() {
        if (this.extension == null) {
            this.extension = new ArrayList<ExtensionType>();
        }
        return this.extension;
    }

    @Nullable
    public String getTransportProfile() {
        return this.transportProfile;
    }

    public void setTransportProfile(@Nullable String string) {
        this.transportProfile = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EndpointType endpointType = (EndpointType)object;
        if (!EqualsHelper.equals((Object)this.endpointURI, (Object)endpointType.endpointURI)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.requireBusinessLevelSignature, (Object)endpointType.requireBusinessLevelSignature)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.minimumAuthenticationLevel, (Object)endpointType.minimumAuthenticationLevel)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.serviceActivationDate, (Object)endpointType.serviceActivationDate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.serviceExpirationDate, (Object)endpointType.serviceExpirationDate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.certificate, (Object)endpointType.certificate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.serviceDescription, (Object)endpointType.serviceDescription)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.technicalContactUrl, (Object)endpointType.technicalContactUrl)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.technicalInformationUrl, (Object)endpointType.technicalInformationUrl)) {
            return false;
        }
        if (!EqualsHelper.equals(this.extension, endpointType.extension)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.transportProfile, (Object)endpointType.transportProfile);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.endpointURI).append((Object)this.requireBusinessLevelSignature).append((Object)this.minimumAuthenticationLevel).append((Object)this.serviceActivationDate).append((Object)this.serviceExpirationDate).append(this.certificate).append((Object)this.serviceDescription).append((Object)this.technicalContactUrl).append((Object)this.technicalInformationUrl).append(this.extension).append((Object)this.transportProfile).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("endpointURI", (Object)this.endpointURI).append("requireBusinessLevelSignature", (Object)this.requireBusinessLevelSignature).append("minimumAuthenticationLevel", (Object)this.minimumAuthenticationLevel).append("serviceActivationDate", (Object)this.serviceActivationDate).append("serviceExpirationDate", (Object)this.serviceExpirationDate).append("certificate", this.certificate).append("serviceDescription", (Object)this.serviceDescription).append("technicalContactUrl", (Object)this.technicalContactUrl).append("technicalInformationUrl", (Object)this.technicalInformationUrl).append("extension", this.extension).append("transportProfile", (Object)this.transportProfile).getToString();
    }

    public void setExtension(@Nullable List<ExtensionType> list) {
        this.extension = list;
    }

    public boolean hasExtensionEntries() {
        return !this.getExtension().isEmpty();
    }

    public boolean hasNoExtensionEntries() {
        return this.getExtension().isEmpty();
    }

    @Nonnegative
    public int getExtensionCount() {
        return this.getExtension().size();
    }

    @Nullable
    public ExtensionType getExtensionAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getExtension().get(n);
    }

    public void addExtension(@Nonnull ExtensionType extensionType) {
        this.getExtension().add(extensionType);
    }

    public void cloneTo(@Nonnull EndpointType endpointType) {
        endpointType.certificate = ArrayHelper.getCopy((byte[])this.certificate);
        endpointType.endpointURI = this.endpointURI;
        ArrayList<ExtensionType> arrayList = new ArrayList<ExtensionType>();
        for (ExtensionType extensionType : this.getExtension()) {
            arrayList.add(extensionType == null ? null : extensionType.clone());
        }
        endpointType.extension = arrayList;
        endpointType.minimumAuthenticationLevel = this.minimumAuthenticationLevel;
        endpointType.requireBusinessLevelSignature = this.requireBusinessLevelSignature;
        endpointType.serviceActivationDate = this.serviceActivationDate;
        endpointType.serviceDescription = this.serviceDescription;
        endpointType.serviceExpirationDate = this.serviceExpirationDate;
        endpointType.technicalContactUrl = this.technicalContactUrl;
        endpointType.technicalInformationUrl = this.technicalInformationUrl;
        endpointType.transportProfile = this.transportProfile;
    }

    @Nonnull
    @ReturnsMutableCopy
    public EndpointType clone() {
        EndpointType endpointType = new EndpointType();
        this.cloneTo(endpointType);
        return endpointType;
    }
}

