/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.utils.BusdoxURLHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IIdentifier
extends Serializable {
    @Nonnull
    public String getScheme();

    default public boolean hasScheme() {
        return StringHelper.hasText((String)this.getScheme());
    }

    default public boolean hasScheme(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getScheme(), (Object)string);
    }

    @Nonnull
    public String getValue();

    default public boolean hasValue() {
        return StringHelper.hasText((String)this.getValue());
    }

    default public boolean hasValue(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getValue(), (Object)string);
    }

    @Nonnull
    @Nonempty
    default public String getURIEncoded() {
        String string = StringHelper.getNotNull((String)this.getScheme());
        String string2 = this.getValue();
        if (string2 == null) {
            throw new IllegalArgumentException("Identifier has a null value: " + this.toString());
        }
        return string + "::" + string2;
    }

    @Nonnull
    default public String getURIPercentEncoded() {
        String string = this.getURIEncoded();
        return BusdoxURLHelper.createPercentEncodedURL(string);
    }
}

