/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.generic.doctype.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.identifier.generic.process.IProcessIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@Deprecated
@ThreadSafe
public final class IdentifierHelper {
    private static final IdentifierHelper s_aInstance = new IdentifierHelper();

    private IdentifierHelper() {
    }

    public static boolean areParticipantIdentifierValuesEqual(@Nullable String string, @Nullable String string2) {
        return EqualsHelper.equalsIgnoreCase((String)string, (String)string2);
    }

    public static boolean areDocumentTypeIdentifierValuesEqual(@Nullable String string, @Nullable String string2) {
        return EqualsHelper.equals((Object)string, (Object)string2);
    }

    public static boolean areProcessIdentifierValuesEqual(@Nullable String string, @Nullable String string2) {
        return EqualsHelper.equals((Object)string, (Object)string2);
    }

    private static int _schemeCompare(@Nullable String string, @Nullable String string2, boolean bl) {
        String string3 = StringHelper.getNotNull((String)string);
        String string4 = StringHelper.getNotNull((String)string2);
        return bl ? string3.compareTo(string4) : string3.compareToIgnoreCase(string4);
    }

    private static boolean _schemeEquals(@Nullable String string, @Nullable String string2, boolean bl) {
        String string3 = StringHelper.getNotNull((String)string);
        String string4 = StringHelper.getNotNull((String)string2);
        return bl ? string3.equals(string4) : string3.equalsIgnoreCase(string4);
    }

    public static boolean areParticipantIdentifiersEqual(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier1");
        ValueEnforcer.notNull((Object)iParticipantIdentifier2, (String)"ParticipantIdentifier2");
        return IdentifierHelper._schemeEquals(iParticipantIdentifier.getScheme(), iParticipantIdentifier2.getScheme(), false) && IdentifierHelper.areParticipantIdentifierValuesEqual(iParticipantIdentifier.getValue(), iParticipantIdentifier2.getValue());
    }

    public static boolean areDocumentTypeIdentifiersEqual(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier2) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeIdentifier1");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier2, (String)"DocumentTypeIdentifier2");
        return IdentifierHelper._schemeEquals(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier2.getScheme(), true) && IdentifierHelper.areDocumentTypeIdentifierValuesEqual(iDocumentTypeIdentifier.getValue(), iDocumentTypeIdentifier2.getValue());
    }

    public static boolean areProcessIdentifiersEqual(@Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier2) {
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessIdentifier1");
        ValueEnforcer.notNull((Object)iProcessIdentifier2, (String)"ProcessIdentifier2");
        return IdentifierHelper._schemeEquals(iProcessIdentifier.getScheme(), iProcessIdentifier2.getScheme(), true) && IdentifierHelper.areProcessIdentifierValuesEqual(iProcessIdentifier.getValue(), iProcessIdentifier2.getValue());
    }

    public static int compareParticipantIdentifiers(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier1");
        ValueEnforcer.notNull((Object)iParticipantIdentifier2, (String)"ParticipantIdentifier2");
        int n = IdentifierHelper._schemeCompare(iParticipantIdentifier.getScheme(), iParticipantIdentifier2.getScheme(), false);
        if (n == 0) {
            n = CompareHelper.compareIgnoreCase((String)iParticipantIdentifier.getValue(), (String)iParticipantIdentifier2.getValue());
        }
        return n;
    }

    public static int compareDocumentTypeIdentifiers(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier2) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeIdentifier1");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier2, (String)"DocumentTypeIdentifier2");
        int n = IdentifierHelper._schemeCompare(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier2.getScheme(), true);
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)iDocumentTypeIdentifier.getValue()), (Comparable)((Object)iDocumentTypeIdentifier2.getValue()));
        }
        return n;
    }

    public static int compareProcessIdentifiers(@Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier2) {
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessIdentifier1");
        ValueEnforcer.notNull((Object)iProcessIdentifier2, (String)"ProcessIdentifier2");
        int n = IdentifierHelper._schemeCompare(iProcessIdentifier.getScheme(), iProcessIdentifier2.getScheme(), true);
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)iProcessIdentifier.getValue()), (Comparable)((Object)iProcessIdentifier2.getValue()));
        }
        return n;
    }
}

