/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.bdxr.doctype;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.bdxr.DocumentIdentifierType;
import com.helger.peppol.identifier.bdxr.doctype.IBDXRDocumentTypeIdentifier;
import com.helger.peppol.identifier.generic.doctype.IDocumentTypeIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BDXRDocumentTypeIdentifier
extends DocumentIdentifierType
implements IBDXRDocumentTypeIdentifier,
Comparable<BDXRDocumentTypeIdentifier>,
ICloneable<BDXRDocumentTypeIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public BDXRDocumentTypeIdentifier(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public BDXRDocumentTypeIdentifier(@Nullable String string, @Nonnull String string2) {
        this.setScheme(StringHelper.hasNoText((String)string) ? null : string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull BDXRDocumentTypeIdentifier bDXRDocumentTypeIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)bDXRDocumentTypeIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)bDXRDocumentTypeIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public BDXRDocumentTypeIdentifier getClone() {
        return new BDXRDocumentTypeIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static BDXRDocumentTypeIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        BDXRDocumentTypeIdentifier bDXRDocumentTypeIdentifier = BDXRDocumentTypeIdentifier.createFromURIPartOrNull(string);
        if (bDXRDocumentTypeIdentifier == null) {
            throw new IllegalArgumentException("BDXR Document type identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return bDXRDocumentTypeIdentifier;
    }

    @Nullable
    @Deprecated
    public static BDXRDocumentTypeIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return BDXRDocumentTypeIdentifier.createIfValid((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Nullable
    public static BDXRDocumentTypeIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (IBDXRDocumentTypeIdentifier.isValidScheme(string) && IBDXRDocumentTypeIdentifier.isValidValue(string2)) {
            return new BDXRDocumentTypeIdentifier(string, string2);
        }
        return null;
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return BDXRDocumentTypeIdentifier.createFromURIPartOrNull(string) != null;
    }
}

