/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.bdxr.participant;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.bdxr.ParticipantIdentifierType;
import com.helger.peppol.identifier.bdxr.participant.IBDXRParticipantIdentifier;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BDXRParticipantIdentifier
extends ParticipantIdentifierType
implements IBDXRParticipantIdentifier,
Comparable<BDXRParticipantIdentifier>,
ICloneable<BDXRParticipantIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public BDXRParticipantIdentifier(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        this(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public BDXRParticipantIdentifier(@Nullable String string, @Nonnull String string2) {
        this.setScheme(StringHelper.hasNoText((String)string) ? null : string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull BDXRParticipantIdentifier bDXRParticipantIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)bDXRParticipantIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)bDXRParticipantIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public BDXRParticipantIdentifier getClone() {
        return new BDXRParticipantIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static BDXRParticipantIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        BDXRParticipantIdentifier bDXRParticipantIdentifier = BDXRParticipantIdentifier.createFromURIPartOrNull(string);
        if (bDXRParticipantIdentifier == null) {
            throw new IllegalArgumentException("BDXR Participant identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return bDXRParticipantIdentifier;
    }

    @Nullable
    @Deprecated
    public static BDXRParticipantIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return BDXRParticipantIdentifier.createIfValid((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Nullable
    public static BDXRParticipantIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (IBDXRParticipantIdentifier.isValidScheme(string) && IBDXRParticipantIdentifier.isValidValue(string2)) {
            return new BDXRParticipantIdentifier(string, string2);
        }
        return null;
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return BDXRParticipantIdentifier.createFromURIPartOrNull(string) != null;
    }
}

