/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.bdxr.process;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.bdxr.ProcessIdentifierType;
import com.helger.peppol.identifier.bdxr.process.IBDXRProcessIdentifier;
import com.helger.peppol.identifier.generic.process.IProcessIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BDXRProcessIdentifier
extends ProcessIdentifierType
implements IBDXRProcessIdentifier,
Comparable<BDXRProcessIdentifier>,
ICloneable<BDXRProcessIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public BDXRProcessIdentifier(@Nonnull IProcessIdentifier iProcessIdentifier) {
        this(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public BDXRProcessIdentifier(@Nullable String string, @Nonnull String string2) {
        this.setScheme(StringHelper.hasNoText((String)string) ? null : string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull BDXRProcessIdentifier bDXRProcessIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)bDXRProcessIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)bDXRProcessIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public BDXRProcessIdentifier getClone() {
        return new BDXRProcessIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static BDXRProcessIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        BDXRProcessIdentifier bDXRProcessIdentifier = BDXRProcessIdentifier.createFromURIPartOrNull(string);
        if (bDXRProcessIdentifier == null) {
            throw new IllegalArgumentException("Process identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return bDXRProcessIdentifier;
    }

    @Nullable
    @Deprecated
    public static BDXRProcessIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return BDXRProcessIdentifier.createIfValid((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Nullable
    public static BDXRProcessIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (IBDXRProcessIdentifier.isValidScheme(string) && IBDXRProcessIdentifier.isValidValue(string2)) {
            return new BDXRProcessIdentifier(string, string2);
        }
        return null;
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return BDXRProcessIdentifier.createFromURIPartOrNull(string) != null;
    }
}

