/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.factory;

import com.helger.peppol.identifier.bdxr.doctype.BDXRDocumentTypeIdentifier;
import com.helger.peppol.identifier.bdxr.participant.BDXRParticipantIdentifier;
import com.helger.peppol.identifier.bdxr.process.BDXRProcessIdentifier;
import com.helger.peppol.identifier.factory.IIdentifierFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BDXRIdentifierFactory
implements IIdentifierFactory {
    public static final BDXRIdentifierFactory INSTANCE = new BDXRIdentifierFactory();

    @Override
    @Nonnull
    public String getDefaultDocumentTypeIdentifierScheme() {
        return "bdx-docid-qns";
    }

    @Override
    public boolean isDocumentTypeIdentifierCaseInsensitive(@Nullable String string) {
        return "bdx-docid-qns".equals(string);
    }

    @Override
    @Nullable
    public BDXRDocumentTypeIdentifier createDocumentTypeIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isDocumentTypeIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return BDXRDocumentTypeIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    @Override
    public boolean isParticipantIdentifierCaseInsensitive(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @Override
    @Nullable
    public BDXRParticipantIdentifier createParticipantIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isParticipantIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return BDXRParticipantIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    @Override
    @Nonnull
    public String getDefaultProcessIdentifierScheme() {
        return "bdx-procid-transport";
    }

    @Override
    public boolean isProcessIdentifierCaseInsensitive(@Nullable String string) {
        return "bdx-procid-transport".equals(string);
    }

    @Override
    @Nullable
    public BDXRProcessIdentifier createProcessIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isProcessIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return BDXRProcessIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }
}

