/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.factory;

import com.helger.peppol.identifier.factory.IIdentifierFactory;
import com.helger.peppol.identifier.peppol.doctype.PeppolDocumentTypeIdentifier;
import com.helger.peppol.identifier.peppol.participant.PeppolParticipantIdentifier;
import com.helger.peppol.identifier.peppol.process.PeppolProcessIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PeppolIdentifierFactory
implements IIdentifierFactory {
    public static final PeppolIdentifierFactory INSTANCE = new PeppolIdentifierFactory();

    @Override
    public boolean isDocumentTypeIdentifierSchemeMandatory() {
        return true;
    }

    @Override
    @Nonnull
    public String getDefaultDocumentTypeIdentifierScheme() {
        return "busdox-docid-qns";
    }

    @Override
    @Nullable
    public PeppolDocumentTypeIdentifier createDocumentTypeIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isDocumentTypeIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return PeppolDocumentTypeIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    @Override
    public boolean isParticipantIdentifierSchemeMandatory() {
        return true;
    }

    @Override
    @Nonnull
    public String getDefaultParticipantIdentifierScheme() {
        return "iso6523-actorid-upis";
    }

    @Override
    public boolean isParticipantIdentifierCaseInsensitive(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @Override
    @Nullable
    public PeppolParticipantIdentifier createParticipantIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isParticipantIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return PeppolParticipantIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    @Override
    @Nonnull
    public String getDefaultProcessIdentifierScheme() {
        return "cenbii-procid-ubl";
    }

    @Override
    @Nullable
    public PeppolProcessIdentifier createProcessIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isProcessIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return PeppolProcessIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }
}

