/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.generic.doctype;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.identifier.generic.doctype.IBusdoxDocumentTypeIdentifierParts;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BusdoxDocumentTypeIdentifierParts
implements IBusdoxDocumentTypeIdentifierParts {
    private final String m_sRootNS;
    private final String m_sLocalName;
    private final String m_sSubTypeIdentifier;

    public BusdoxDocumentTypeIdentifierParts(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RootNS");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"LocalName");
        this.m_sRootNS = string;
        this.m_sLocalName = string2;
        this.m_sSubTypeIdentifier = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getRootNS() {
        return this.m_sRootNS;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    @Nullable
    public String getSubTypeIdentifier() {
        return this.m_sSubTypeIdentifier;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsDocumentTypeIdentifierValue() {
        return BusdoxDocumentTypeIdentifierParts.getAsDocumentTypeIdentifierValue(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BusdoxDocumentTypeIdentifierParts busdoxDocumentTypeIdentifierParts = (BusdoxDocumentTypeIdentifierParts)object;
        return this.m_sRootNS.equals(busdoxDocumentTypeIdentifierParts.m_sRootNS) && this.m_sLocalName.equals(busdoxDocumentTypeIdentifierParts.m_sLocalName) && EqualsHelper.equals((Object)this.m_sSubTypeIdentifier, (Object)busdoxDocumentTypeIdentifierParts.m_sSubTypeIdentifier);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRootNS).append((Object)this.m_sLocalName).append((Object)this.m_sSubTypeIdentifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("rootNS", (Object)this.m_sRootNS).append("localName", (Object)this.m_sLocalName).append("subTypeIdentifier", (Object)this.m_sSubTypeIdentifier).getToString();
    }

    @Nonnull
    @Nonempty
    public static String getAsDocumentTypeIdentifierValue(@Nonnull IBusdoxDocumentTypeIdentifierParts iBusdoxDocumentTypeIdentifierParts) {
        ValueEnforcer.notNull((Object)iBusdoxDocumentTypeIdentifierParts, (String)"Parts");
        String string = iBusdoxDocumentTypeIdentifierParts.getRootNS() + "::" + iBusdoxDocumentTypeIdentifierParts.getLocalName();
        String string2 = iBusdoxDocumentTypeIdentifierParts.getSubTypeIdentifier();
        if (StringHelper.hasText((String)string2)) {
            string = string + "##" + string2;
        }
        return string;
    }

    @Nonnull
    public static IBusdoxDocumentTypeIdentifierParts extractFromString(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DocumentTypeIdentifier");
        ICommonsList iCommonsList = StringHelper.getExploded((String)"##", (String)string, (int)2);
        ICommonsList iCommonsList2 = StringHelper.getExploded((String)"::", (String)((String)iCommonsList.get(0)), (int)2);
        if (iCommonsList2.size() < 2) {
            throw new IllegalArgumentException("The document identifier '" + string + "' is missing the separation between root namespace and local name!");
        }
        String string2 = (String)iCommonsList2.get(0);
        String string3 = (String)iCommonsList2.get(1);
        String string4 = iCommonsList.size() == 1 ? null : (String)iCommonsList.get(1);
        return new BusdoxDocumentTypeIdentifierParts(string2, string3, string4);
    }
}

