/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.generic.process;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.ProcessIdentifierType;
import com.helger.peppol.identifier.generic.process.IProcessIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleProcessIdentifier
extends ProcessIdentifierType
implements Comparable<SimpleProcessIdentifier>,
ICloneable<SimpleProcessIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public SimpleProcessIdentifier(@Nonnull IProcessIdentifier iProcessIdentifier) {
        this(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public SimpleProcessIdentifier(@Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull SimpleProcessIdentifier simpleProcessIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)simpleProcessIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)simpleProcessIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public SimpleProcessIdentifier getClone() {
        return new SimpleProcessIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static SimpleProcessIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        SimpleProcessIdentifier simpleProcessIdentifier = SimpleProcessIdentifier.createFromURIPartOrNull(string);
        if (simpleProcessIdentifier == null) {
            throw new IllegalArgumentException("Process identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return simpleProcessIdentifier;
    }

    @Nullable
    @Deprecated
    public static SimpleProcessIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return new SimpleProcessIdentifier((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return SimpleProcessIdentifier.createFromURIPartOrNull(string) != null;
    }
}

