/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.doctype;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.identifier.generic.doctype.BusdoxDocumentTypeIdentifierParts;
import com.helger.peppol.identifier.generic.doctype.IBusdoxDocumentTypeIdentifierParts;
import com.helger.peppol.identifier.peppol.doctype.IPeppolDocumentTypeIdentifierParts;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class OpenPeppolDocumentTypeIdentifierParts
implements IPeppolDocumentTypeIdentifierParts {
    public static final String TRANSACTIONID_SEPARATOR = ":extended:";
    public static final String EXTENSION_SEPARATOR = ":extended:";
    public static final String VERSION_SEPARATOR = "::";
    private final IBusdoxDocumentTypeIdentifierParts m_aBusdoxParts;
    private final String m_sTransactionID;
    private final ICommonsList<String> m_aExtensionIDs;
    private final String m_sVersion;

    @Nonnull
    private static String _buildSubTypeIdentifier(@Nonnull String string, @Nonnull @Nonempty List<String> list, @Nonnull String string2) {
        return string + ":extended:" + StringHelper.getImploded((String)":extended:", list) + VERSION_SEPARATOR + string2;
    }

    private OpenPeppolDocumentTypeIdentifierParts(@Nonnull IBusdoxDocumentTypeIdentifierParts iBusdoxDocumentTypeIdentifierParts, @Nonnull @Nonempty String string, @Nonnull @Nonempty List<String> list, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TransactionID");
        ValueEnforcer.notEmpty(list, (String)"ExtensionIDs");
        for (String string3 : list) {
            if (!StringHelper.hasNoText((String)string3)) continue;
            throw new IllegalArgumentException("the extension IDs contain at least one empty element!");
        }
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Version");
        this.m_aBusdoxParts = iBusdoxDocumentTypeIdentifierParts;
        this.m_sTransactionID = string;
        this.m_aExtensionIDs = new CommonsArrayList(list);
        this.m_sVersion = string2;
    }

    public OpenPeppolDocumentTypeIdentifierParts(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty List<String> list, @Nonnull @Nonempty String string4) {
        this(new BusdoxDocumentTypeIdentifierParts(string, string2, OpenPeppolDocumentTypeIdentifierParts._buildSubTypeIdentifier(string3, list, string4)), string3, list, string4);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getRootNS() {
        return this.m_aBusdoxParts.getRootNS();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_aBusdoxParts.getLocalName();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSubTypeIdentifier() {
        return this.m_aBusdoxParts.getSubTypeIdentifier();
    }

    @Override
    @Nonnull
    public String getTransactionID() {
        return this.m_sTransactionID;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<String> getExtensionIDs() {
        return (ICommonsList)this.m_aExtensionIDs.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getVersion() {
        return this.m_sVersion;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsUBLCustomizationID() {
        return this.m_sTransactionID + ":extended:" + StringHelper.getImploded((String)":extended:", this.m_aExtensionIDs);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsDocumentTypeIdentifierValue() {
        return this.m_aBusdoxParts.getAsDocumentTypeIdentifierValue();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("busdoxParts", (Object)this.m_aBusdoxParts).append("transactionID", (Object)this.m_sTransactionID).append("extensionIDs", this.m_aExtensionIDs).append("version", (Object)this.m_sVersion).getToString();
    }

    @Nonnull
    public static IPeppolDocumentTypeIdentifierParts extractFromString(@Nonnull @Nonempty String string) {
        IBusdoxDocumentTypeIdentifierParts iBusdoxDocumentTypeIdentifierParts = BusdoxDocumentTypeIdentifierParts.extractFromString(string);
        String string2 = iBusdoxDocumentTypeIdentifierParts.getSubTypeIdentifier();
        if (StringHelper.hasNoText((String)string2)) {
            throw new IllegalArgumentException("The passed document identifier has an empty sub type identifier which is not PEPPOL compliant!");
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string2, (String)VERSION_SEPARATOR, (int)2);
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("The sub type identifier '" + string2 + "' is missing the separation between customization ID and version!");
        }
        String string3 = stringArray[1];
        if (StringHelper.hasNoText((String)string3)) {
            throw new IllegalArgumentException("The sub type identifier '" + string2 + "' contains an empty version!");
        }
        String string4 = stringArray[0];
        String[] stringArray2 = RegExHelper.getSplitToArray((CharSequence)string4, (String)":extended:", (int)2);
        if (stringArray2.length < 2) {
            throw new IllegalArgumentException("The sub type identifier '" + string2 + "' is missing the separation between transaction ID and the extensions!");
        }
        String string5 = stringArray2[0];
        if (StringHelper.hasNoText((String)string5)) {
            throw new IllegalArgumentException("The customization ID '" + string4 + "' contains an empty transaction ID!");
        }
        String string6 = stringArray2[1];
        if (StringHelper.hasNoText((String)string6)) {
            throw new IllegalArgumentException("The customization ID '" + string4 + "' contains an empty customization ID!");
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)":extended:", (String)string6);
        return new OpenPeppolDocumentTypeIdentifierParts(iBusdoxDocumentTypeIdentifierParts, string5, (List<String>)iCommonsList, string3);
    }
}

