/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.doctype;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.DocumentIdentifierType;
import com.helger.peppol.identifier.generic.doctype.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.peppol.doctype.IMutablePeppolDocumentTypeIdentifier;
import com.helger.peppol.identifier.peppol.doctype.IPeppolDocumentTypeIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PeppolDocumentTypeIdentifier
extends DocumentIdentifierType
implements IMutablePeppolDocumentTypeIdentifier,
Comparable<PeppolDocumentTypeIdentifier>,
ICloneable<PeppolDocumentTypeIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolDocumentTypeIdentifier(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue());
    }

    @Nonnull
    private static String _verifyScheme(@Nullable String string) {
        if (!IPeppolDocumentTypeIdentifier.isValidScheme(string)) {
            throw new IllegalArgumentException("Peppol Document Type identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull String string) {
        if (!IPeppolDocumentTypeIdentifier.isValidValue(string)) {
            throw new IllegalArgumentException("Peppol Document Type identifier value '" + string + "' is invalid!");
        }
        return string;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolDocumentTypeIdentifier(@Nullable String string, @Nonnull String string2) {
        this(true, PeppolDocumentTypeIdentifier._verifyScheme(string), PeppolDocumentTypeIdentifier._verifyValue(string2));
    }

    protected PeppolDocumentTypeIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull PeppolDocumentTypeIdentifier peppolDocumentTypeIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolDocumentTypeIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolDocumentTypeIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolDocumentTypeIdentifier getClone() {
        return new PeppolDocumentTypeIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static PeppolDocumentTypeIdentifier createWithDefaultScheme(@Nonnull String string) {
        return new PeppolDocumentTypeIdentifier("busdox-docid-qns", string);
    }

    @Nonnull
    @Deprecated
    public static PeppolDocumentTypeIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        PeppolDocumentTypeIdentifier peppolDocumentTypeIdentifier = PeppolDocumentTypeIdentifier.createFromURIPartOrNull(string);
        if (peppolDocumentTypeIdentifier == null) {
            throw new IllegalArgumentException("Peppol Document type identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return peppolDocumentTypeIdentifier;
    }

    @Nullable
    @Deprecated
    public static PeppolDocumentTypeIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return PeppolDocumentTypeIdentifier.createIfValid((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Nullable
    public static PeppolDocumentTypeIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (IPeppolDocumentTypeIdentifier.isValidScheme(string) && IPeppolDocumentTypeIdentifier.isValidValue(string2)) {
            return new PeppolDocumentTypeIdentifier(true, string, string2);
        }
        return null;
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return PeppolDocumentTypeIdentifier.createFromURIPartOrNull(string) != null;
    }
}

