/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.doctype;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.peppol.identifier.peppol.doctype.EPredefinedDocumentTypeIdentifier;
import com.helger.peppol.identifier.peppol.doctype.IPeppolPredefinedDocumentTypeIdentifier;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PredefinedDocumentTypeIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedDocumentTypeIdentifier> s_aCodes = new CommonsHashMap();
    private static final PredefinedDocumentTypeIdentifierManager s_aInstance;

    private PredefinedDocumentTypeIdentifierManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsCollection<IPeppolPredefinedDocumentTypeIdentifier> getAllDocumentTypeIdentifiers() {
        return s_aCodes.copyOfValues();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllDocumentTypeIdentifierIDs() {
        return s_aCodes.copyOfKeySet();
    }

    @Nullable
    public static IPeppolPredefinedDocumentTypeIdentifier getDocumentTypeIdentifierOfID(@Nullable String string) {
        if (string != null) {
            for (Map.Entry entry : s_aCodes.entrySet()) {
                if (!string.equals(entry.getKey())) continue;
                return (IPeppolPredefinedDocumentTypeIdentifier)entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsDocumentTypeIdentifierWithID(@Nullable String string) {
        return PredefinedDocumentTypeIdentifierManager.getDocumentTypeIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier : EPredefinedDocumentTypeIdentifier.values()) {
            s_aCodes.put((Object)ePredefinedDocumentTypeIdentifier.getValue(), (Object)ePredefinedDocumentTypeIdentifier);
        }
        s_aInstance = new PredefinedDocumentTypeIdentifierManager();
    }
}

