/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.issuingagency;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.version.Version;
import com.helger.peppol.identifier.factory.PeppolIdentifierFactory;
import com.helger.peppol.identifier.peppol.issuingagency.IIdentifierIssuingAgency;
import com.helger.peppol.identifier.peppol.participant.PeppolParticipantIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@CodingStyleguideUnaware
public enum EPredefinedIdentifierIssuingAgency implements IIdentifierIssuingAgency
{
    FR_SIRENE("FR:SIRENE", "Institut National de la Statistique et des Etudes Economiques, (I.N.S.E.E.)", "0002", false, Version.parse((String)"1.0.0")),
    SE_ORGNR("SE:ORGNR", "The National Tax Board", "0007", false, Version.parse((String)"1.0.0")),
    FR_SIRET("FR:SIRET", "DU PONT DE NEMOURS", "0009", false, Version.parse((String)"1.1.1")),
    FI_OVT("FI:OVT", "National Board of Taxes, (Verohallitus)", "0037", false, Version.parse((String)"1.0.0")),
    DUNS("DUNS", "Dun and Bradstreet Ltd", "0060", false, Version.parse((String)"1.0.0")),
    GLN("GLN", "GS1 GLN", "0088", false, Version.parse((String)"1.0.0")),
    DK_P("DK:P", "Danish Chamber of Commerce", "0096", false, Version.parse((String)"1.0.0")),
    IT_FTI("IT:FTI", "FTI - Ediforum Italia", "0097", false, Version.parse((String)"1.0.0")),
    NL_KVK("NL:KVK", "Vereniging van Kamers van Koophandel en Fabrieken in Nederland, Scheme", "0106", false, Version.parse((String)"1.1.2")),
    IT_SIA("IT:SIA", "SIA-Societ\u00e0 Interbancaria per l'Automazione S.p.A.", "0135", false, Version.parse((String)"1.0.0")),
    IT_SECETI("IT:SECETI", "Servizi Centralizzati SECETI S.p.A.", "0142", false, Version.parse((String)"1.0.0")),
    DIGST("DIGST", "DIGSTORG", "0184", false, Version.parse((String)"1.2.1")),
    DK_CPR("DK:CPR", "Danish Ministry of the Interior and Health", "9901", false, Version.parse((String)"1.0.0")),
    DK_CVR("DK:CVR", "The Danish Commerce and Companies Agency", "9902", false, Version.parse((String)"1.0.0")),
    DK_SE("DK:SE", "Danish Ministry of Taxation, Central Customs and Tax Administration", "9904", false, Version.parse((String)"1.0.0")),
    DK_VANS("DK:VANS", "Danish VANS providers", "9905", false, Version.parse((String)"1.0.0")),
    IT_VAT("IT:VAT", "Ufficio responsabile gestione partite IVA", "9906", false, Version.parse((String)"1.0.0")),
    IT_CF("IT:CF", "TAX Authority", "9907", false, Version.parse((String)"1.0.0")),
    NO_ORGNR("NO:ORGNR", "Enhetsregisteret ved Bronnoysundregisterne", "9908", false, Version.parse((String)"1.0.0")),
    NO_VAT("NO:VAT", "Enhetsregisteret ved Bronnoysundregisterne", "9909", true, Version.parse((String)"1.0.0")),
    HU_VAT("HU:VAT", null, "9910", false, Version.parse((String)"1.0.0")),
    EU_VAT("EU:VAT", "National ministries of Economy", "9912", true, Version.parse((String)"1.0.0")),
    EU_REID("EU:REID", "Business Registers Network", "9913", false, Version.parse((String)"1.0.0")),
    AT_VAT("AT:VAT", "\u00d6sterreichische Umsatzsteuer-Identifikationsnummer", "9914", false, Version.parse((String)"1.0.0")),
    AT_GOV("AT:GOV", "\u00d6sterreichisches Verwaltungs bzw. Organisationskennzeichen", "9915", false, Version.parse((String)"1.0.0")),
    AT_CID("AT:CID", "Firmenidentifikationsnummer der Statistik Austria", "9916", true, Version.parse((String)"1.0.0")),
    IS_KT("IS:KT", "Icelandic National Registry", "9917", false, Version.parse((String)"1.0.0")),
    IBAN("IBAN", "SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T", "9918", false, Version.parse((String)"1.0.1")),
    AT_KUR("AT:KUR", "Kennziffer des Unternehmensregisters", "9919", false, Version.parse((String)"1.0.2")),
    ES_VAT("ES:VAT", "Agencia Espa\u00f1ola de Administraci\u00f3n Tributaria", "9920", false, Version.parse((String)"1.0.2")),
    IT_IPA("IT:IPA", "Indice delle Pubbliche Amministrazioni", "9921", false, Version.parse((String)"1.1.0")),
    AD_VAT("AD:VAT", "Andorra VAT number", "9922", false, Version.parse((String)"1.1.0")),
    AL_VAT("AL:VAT", "Albania VAT number", "9923", false, Version.parse((String)"1.1.0")),
    BA_VAT("BA:VAT", "Bosnia and Herzegovina VAT number", "9924", false, Version.parse((String)"1.1.0")),
    BE_VAT("BE:VAT", "Belgium VAT number", "9925", false, Version.parse((String)"1.1.0")),
    BG_VAT("BG:VAT", "Bulgaria VAT number", "9926", false, Version.parse((String)"1.1.0")),
    CH_VAT("CH:VAT", "Switzerland VAT number", "9927", false, Version.parse((String)"1.1.0")),
    CY_VAT("CY:VAT", "Cyprus VAT number", "9928", false, Version.parse((String)"1.1.0")),
    CZ_VAT("CZ:VAT", "Czech Republic VAT number", "9929", false, Version.parse((String)"1.1.0")),
    DE_VAT("DE:VAT", "Germany VAT number", "9930", false, Version.parse((String)"1.1.0")),
    EE_VAT("EE:VAT", "Estonia VAT number", "9931", false, Version.parse((String)"1.1.0")),
    GB_VAT("GB:VAT", "United Kingdom VAT number", "9932", false, Version.parse((String)"1.1.0")),
    GR_VAT("GR:VAT", "Greece VAT number", "9933", false, Version.parse((String)"1.1.0")),
    HR_VAT("HR:VAT", "Croatia VAT number", "9934", false, Version.parse((String)"1.1.0")),
    IE_VAT("IE:VAT", "Ireland VAT number", "9935", false, Version.parse((String)"1.1.0")),
    LI_VAT("LI:VAT", "Liechtenstein VAT number", "9936", false, Version.parse((String)"1.1.0")),
    LT_VAT("LT:VAT", "Lithuania VAT number", "9937", false, Version.parse((String)"1.1.0")),
    LU_VAT("LU:VAT", "Luxemburg VAT number", "9938", false, Version.parse((String)"1.1.0")),
    LV_VAT("LV:VAT", "Latvia VAT number", "9939", false, Version.parse((String)"1.1.0")),
    MC_VAT("MC:VAT", "Monaco VAT number", "9940", false, Version.parse((String)"1.1.0")),
    ME_VAT("ME:VAT", "Montenegro VAT number", "9941", false, Version.parse((String)"1.1.0")),
    MK_VAT("MK:VAT", "Macedonia, the former Yugoslav Republic of VAT number", "9942", false, Version.parse((String)"1.1.0")),
    MT_VAT("MT:VAT", "Malta VAT number", "9943", false, Version.parse((String)"1.1.0")),
    NL_VAT("NL:VAT", "Netherlands VAT number", "9944", false, Version.parse((String)"1.1.0")),
    PL_VAT("PL:VAT", "Poland VAT number", "9945", false, Version.parse((String)"1.1.0")),
    PT_VAT("PT:VAT", "Portugal VAT number", "9946", false, Version.parse((String)"1.1.0")),
    RO_VAT("RO:VAT", "Romania VAT number", "9947", false, Version.parse((String)"1.1.0")),
    RS_VAT("RS:VAT", "Serbia VAT number", "9948", false, Version.parse((String)"1.1.0")),
    SI_VAT("SI:VAT", "Slovenia VAT number", "9949", false, Version.parse((String)"1.1.0")),
    SK_VAT("SK:VAT", "Slovakia VAT number", "9950", false, Version.parse((String)"1.1.0")),
    SM_VAT("SM:VAT", "San Marino VAT number", "9951", false, Version.parse((String)"1.1.0")),
    TR_VAT("TR:VAT", "Turkey VAT number", "9952", false, Version.parse((String)"1.1.0")),
    VA_VAT("VA:VAT", "Holy See (Vatican City State) VAT number", "9953", false, Version.parse((String)"1.1.0")),
    NL_OIN("NL:OIN", "Dutch Originator's Identification Number", "9954", false, Version.parse((String)"1.1.3")),
    SE_VAT("SE:VAT", "Swedish VAT number", "9955", false, Version.parse((String)"1.2.0")),
    BE_CBE("BE:CBE", "Belgian Crossroad Bank of Enterprises ", "9956", false, Version.parse((String)"1.2.1")),
    FR_VAT("FR:VAT", "French VAT number", "9957", false, Version.parse((String)"1.2.1"));

    private final String m_sSchemeID;
    private final String m_sSchemeAgency;
    private final String m_sISO6523;
    private final boolean m_bDeprecated;
    private final Version m_aSince;

    private EPredefinedIdentifierIssuingAgency(@Nonnull @Nonempty String string2, String string3, @Nonnull String string4, boolean bl, Version version) {
        this.m_sSchemeID = string2;
        this.m_sSchemeAgency = string3;
        this.m_sISO6523 = string4;
        this.m_bDeprecated = bl;
        this.m_aSince = version;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSchemeID() {
        return this.m_sSchemeID;
    }

    @Override
    @Nullable
    public String getSchemeAgency() {
        return this.m_sSchemeAgency;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getISO6523Code() {
        return this.m_sISO6523;
    }

    @Override
    @Nonnull
    @Nonempty
    public String createIdentifierValue(@Nonnull @Nonempty String string) {
        return this.m_sISO6523 + ":" + string;
    }

    @Override
    @Nonnull
    public PeppolParticipantIdentifier createParticipantIdentifier(@Nonnull @Nonempty String string) {
        return (PeppolParticipantIdentifier)PeppolIdentifierFactory.INSTANCE.createParticipantIdentifierWithDefaultScheme(this.createIdentifierValue(string));
    }

    @Override
    public boolean isDeprecated() {
        return this.m_bDeprecated;
    }

    @Override
    @Nonnull
    public Version getSince() {
        return this.m_aSince;
    }
}

