/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.issuingagency;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.factory.PeppolIdentifierFactory;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.identifier.peppol.issuingagency.EPredefinedIdentifierIssuingAgency;
import com.helger.peppol.identifier.peppol.issuingagency.IIdentifierIssuingAgency;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IdentifierIssuingAgencyManager {
    private static final ICommonsList<IIdentifierIssuingAgency> s_aCodes = new CommonsArrayList();
    private static final IdentifierIssuingAgencyManager s_aInstance;

    private IdentifierIssuingAgencyManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsList<? extends IIdentifierIssuingAgency> getAllAgencies() {
        return (ICommonsList)s_aCodes.getClone();
    }

    @Nullable
    public static IIdentifierIssuingAgency getAgencyOfISO6523Code(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (IIdentifierIssuingAgency iIdentifierIssuingAgency : s_aCodes) {
                if (!iIdentifierIssuingAgency.getISO6523Code().equalsIgnoreCase(string)) continue;
                return iIdentifierIssuingAgency;
            }
        }
        return null;
    }

    public static boolean containsAgencyWithISO6523Code(@Nullable String string) {
        return IdentifierIssuingAgencyManager.getAgencyOfISO6523Code(string) != null;
    }

    @Nullable
    public static String getSchemeIDOfISO6523Code(@Nullable String string) {
        IIdentifierIssuingAgency iIdentifierIssuingAgency = IdentifierIssuingAgencyManager.getAgencyOfISO6523Code(string);
        return iIdentifierIssuingAgency == null ? null : iIdentifierIssuingAgency.getSchemeID();
    }

    @Nullable
    public static IIdentifierIssuingAgency getAgencyOfSchemeID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (IIdentifierIssuingAgency iIdentifierIssuingAgency : s_aCodes) {
                if (!iIdentifierIssuingAgency.getSchemeID().equalsIgnoreCase(string)) continue;
                return iIdentifierIssuingAgency;
            }
        }
        return null;
    }

    public static boolean containsAgencyWithSchemeID(@Nullable String string) {
        return IdentifierIssuingAgencyManager.getAgencyOfSchemeID(string) != null;
    }

    @Nullable
    public static String getISO6523CodeOfSchemeID(@Nullable String string) {
        IIdentifierIssuingAgency iIdentifierIssuingAgency = IdentifierIssuingAgencyManager.getAgencyOfSchemeID(string);
        return iIdentifierIssuingAgency == null ? null : iIdentifierIssuingAgency.getISO6523Code();
    }

    @Nonnull
    public static ETriState isAgencyWithISO6523CodeDeprecated(@Nullable String string) {
        IIdentifierIssuingAgency iIdentifierIssuingAgency = IdentifierIssuingAgencyManager.getAgencyOfISO6523Code(string);
        return iIdentifierIssuingAgency == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)iIdentifierIssuingAgency.isDeprecated());
    }

    @Nonnull
    public static ETriState isAgencyWithSchemeIDDeprecated(@Nullable String string) {
        IIdentifierIssuingAgency iIdentifierIssuingAgency = IdentifierIssuingAgencyManager.getAgencyOfSchemeID(string);
        return iIdentifierIssuingAgency == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)iIdentifierIssuingAgency.isDeprecated());
    }

    @Nullable
    public static IIdentifierIssuingAgency getAgencyOfIdentifier(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        String string;
        if (iParticipantIdentifier != null && iParticipantIdentifier.hasScheme(PeppolIdentifierFactory.INSTANCE.getDefaultParticipantIdentifierScheme()) && (string = iParticipantIdentifier.getValue()).length() > 5) {
            return IdentifierIssuingAgencyManager.getAgencyOfISO6523Code(string.substring(0, 4));
        }
        return null;
    }

    static {
        for (EPredefinedIdentifierIssuingAgency ePredefinedIdentifierIssuingAgency : EPredefinedIdentifierIssuingAgency.values()) {
            s_aCodes.add((Object)ePredefinedIdentifierIssuingAgency);
        }
        s_aInstance = new IdentifierIssuingAgencyManager();
    }
}

