/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.participant;

import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.identifier.peppol.IPeppolIdentifier;
import com.helger.peppol.identifier.peppol.PeppolIdentifierHelper;
import com.helger.peppol.identifier.peppol.validator.IdentifierValidator;
import com.helger.peppol.url.PeppolURLProvider;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPeppolParticipantIdentifier
extends IPeppolIdentifier,
IParticipantIdentifier {
    public static final String PARTICIPANT_IDENTIFIER_SCHEME_REGEX = "[a-z0-9]+-[a-z0-9]+-[a-z0-9]+";

    @Override
    default public boolean hasDefaultScheme() {
        return this.hasScheme("iso6523-actorid-upis");
    }

    default public boolean isSemanticallyValid() {
        return IdentifierValidator.isValidParticipantIdentifier(this);
    }

    @Nullable
    default public String getIssuingAgencyID() {
        if (this.hasDefaultScheme()) {
            return (String)StringHelper.getExploded((char)':', (String)this.getValue(), (int)2).getAtIndex(0);
        }
        return null;
    }

    @Nullable
    default public String getLocalParticipantID() {
        if (this.hasDefaultScheme()) {
            return (String)StringHelper.getExploded((char)':', (String)this.getValue(), (int)2).getAtIndex(1);
        }
        return null;
    }

    public static boolean isValidScheme(@Nullable String string) {
        if (!PeppolIdentifierHelper.isValidIdentifierScheme(string)) {
            return false;
        }
        return RegExHelper.stringMatchesPattern((String)PARTICIPANT_IDENTIFIER_SCHEME_REGEX, (String)string.toLowerCase(PeppolURLProvider.URL_LOCALE));
    }

    public static boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0 || n > 50) {
            return false;
        }
        return PeppolIdentifierHelper.areCharsetChecksDisabled() || StandardCharsets.US_ASCII.newEncoder().canEncode(string);
    }

    public static boolean isValidValueWithDefaultScheme(@Nonnull String string) {
        ICommonsList iCommonsList = StringHelper.getExploded((char)':', (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return false;
        }
        String string2 = (String)iCommonsList.get(0);
        if (string2.length() != 4 || !StringParser.isUnsignedInt((String)string2)) {
            return false;
        }
        String string3 = ((String)iCommonsList.get(1)).trim();
        return string3.length() > 0;
    }
}

