/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.participant;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.ParticipantIdentifierType;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.identifier.peppol.participant.IMutablePeppolParticipantIdentifier;
import com.helger.peppol.identifier.peppol.participant.IPeppolParticipantIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PeppolParticipantIdentifier
extends ParticipantIdentifierType
implements IMutablePeppolParticipantIdentifier,
Comparable<PeppolParticipantIdentifier>,
ICloneable<PeppolParticipantIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolParticipantIdentifier(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        this(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @Nonnull
    private static String _verifyScheme(@Nullable String string) {
        if (!IPeppolParticipantIdentifier.isValidScheme(string)) {
            throw new IllegalArgumentException("Peppol Participant identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull String string) {
        if (!IPeppolParticipantIdentifier.isValidValue(string)) {
            throw new IllegalArgumentException("Peppol Participant identifier value '" + string + "' is invalid!");
        }
        return string;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolParticipantIdentifier(@Nullable String string, @Nonnull String string2) {
        this(true, PeppolParticipantIdentifier._verifyScheme(string), PeppolParticipantIdentifier._verifyValue(string2));
    }

    protected PeppolParticipantIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull PeppolParticipantIdentifier peppolParticipantIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolParticipantIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolParticipantIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolParticipantIdentifier getClone() {
        return new PeppolParticipantIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static PeppolParticipantIdentifier createWithDefaultScheme(@Nonnull String string) {
        return new PeppolParticipantIdentifier("iso6523-actorid-upis", string);
    }

    @Nonnull
    @Deprecated
    public static PeppolParticipantIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        PeppolParticipantIdentifier peppolParticipantIdentifier = PeppolParticipantIdentifier.createFromURIPartOrNull(string);
        if (peppolParticipantIdentifier == null) {
            throw new IllegalArgumentException("Peppol Participant identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return peppolParticipantIdentifier;
    }

    @Nullable
    @Deprecated
    public static PeppolParticipantIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return PeppolParticipantIdentifier.createIfValid((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Nullable
    public static PeppolParticipantIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (IPeppolParticipantIdentifier.isValidScheme(string) && IPeppolParticipantIdentifier.isValidValue(string2)) {
            return new PeppolParticipantIdentifier(true, string, string2);
        }
        return null;
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return PeppolParticipantIdentifier.createFromURIPartOrNull(string) != null;
    }
}

