/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.process;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.version.Version;
import com.helger.peppol.identifier.generic.process.IProcessIdentifier;
import com.helger.peppol.identifier.peppol.doctype.EPredefinedDocumentTypeIdentifier;
import com.helger.peppol.identifier.peppol.doctype.IPeppolPredefinedDocumentTypeIdentifier;
import com.helger.peppol.identifier.peppol.process.IPeppolPredefinedProcessIdentifier;
import com.helger.peppol.identifier.peppol.process.PeppolProcessIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@CodingStyleguideUnaware
public enum EPredefinedProcessIdentifier implements IPeppolPredefinedProcessIdentifier
{
    urn_www_cenbii_eu_profile_bii01_ver1_0("urn:www.cenbii.eu:profile:bii01:ver1.0", "urn:www.peppol.eu:bis:peppol1a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.CATALOGUE_T019_BIS1A, EPredefinedDocumentTypeIdentifier.APPLICATIONRESPONSE_T057_BIS1A, EPredefinedDocumentTypeIdentifier.APPLICATIONRESPONSE_T058_BIS1A}, Version.parse((String)"1.0.0")),
    urn_www_cenbii_eu_profile_bii01_ver2_0("urn:www.cenbii.eu:profile:bii01:ver2.0", "urn:www.peppol.eu:bis:peppol1a:ver4.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.CATALOGUE_T019_BIS1A_V40}, Version.parse((String)"1.2.0")),
    urn_www_cenbii_eu_profile_bii03_ver1_0("urn:www.cenbii.eu:profile:bii03:ver1.0", "urn:www.peppol.eu:bis:peppol3a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.ORDER_T001_BIS3A}, Version.parse((String)"1.0.0")),
    urn_www_cenbii_eu_profile_bii03_ver2_0("urn:www.cenbii.eu:profile:bii03:ver2.0", "urn:www.peppol.eu:bis:peppol03a:ver2.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.ORDER_T001_BIS03A_V20}, Version.parse((String)"1.2.0")),
    urn_www_cenbii_eu_profile_bii04_ver1_0("urn:www.cenbii.eu:profile:bii04:ver1.0", "urn:www.peppol.eu:bis:peppol4a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.INVOICE_T010_BIS4A}, Version.parse((String)"1.0.0")),
    urn_www_cenbii_eu_profile_bii04_ver2_0("urn:www.cenbii.eu:profile:bii04:ver2.0", "urn:www.peppol.eu:bis:peppol4a:ver2.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.INVOICE_T010_BIS4A_V20}, Version.parse((String)"1.2.0")),
    urn_www_cenbii_eu_profile_bii05_ver1_0("urn:www.cenbii.eu:profile:bii05:ver1.0", "urn:www.peppol.eu:bis:peppol5a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.INVOICE_T010_BIS5A, EPredefinedDocumentTypeIdentifier.CREDITNOTE_T014_BIS5A, EPredefinedDocumentTypeIdentifier.INVOICE_T015_BIS5A}, Version.parse((String)"1.1.0")),
    urn_www_cenbii_eu_profile_bii05_ver2_0("urn:www.cenbii.eu:profile:bii05:ver2.0", "urn:www.peppol.eu:bis:peppol5a:ver2.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.INVOICE_T010_BIS5A_V20, EPredefinedDocumentTypeIdentifier.CREDITNOTE_T014_BIS5A_V20}, Version.parse((String)"1.2.0")),
    urn_www_cenbii_eu_profile_bii06_ver1_0("urn:www.cenbii.eu:profile:bii06:ver1.0", "urn:www.peppol.eu:bis:peppol6a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.ORDER_T001_BIS6A, EPredefinedDocumentTypeIdentifier.ORDERRESPONSESIMPLE_T002_BIS6A, EPredefinedDocumentTypeIdentifier.ORDERRESPONSESIMPLE_T003_BIS6A, EPredefinedDocumentTypeIdentifier.INVOICE_T010_BIS6A, EPredefinedDocumentTypeIdentifier.CREDITNOTE_T014_BIS6A, EPredefinedDocumentTypeIdentifier.INVOICE_T015_BIS6A}, Version.parse((String)"1.0.0")),
    urn_www_cenbii_eu_profile_bii28_ver2_0("urn:www.cenbii.eu:profile:bii28:ver2.0", "urn:www.peppol.eu:bis:peppol28a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.ORDER_T001_BIS28A, EPredefinedDocumentTypeIdentifier.ORDER_T076_BIS28A}, Version.parse((String)"1.2.0")),
    urn_www_cenbii_eu_profile_bii30_ver2_0("urn:www.cenbii.eu:profile:bii30:ver2.0", "urn:www.peppol.eu:bis:peppol30a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.DESPATCHADVICE_T016_BIS30A}, Version.parse((String)"1.2.0")),
    urn_www_cenbii_eu_profile_bii36_ver2_0("urn:www.cenbii.eu:profile:bii36:ver2.0", "urn:www.peppol.eu:bis:peppol36a:ver1.0", new EPredefinedDocumentTypeIdentifier[]{EPredefinedDocumentTypeIdentifier.APPLICATIONRESPONSE_T071_BIS36A}, Version.parse((String)"1.2.0"));

    @Deprecated
    public static final EPredefinedProcessIdentifier BIS1A;
    public static final EPredefinedProcessIdentifier BIS1A_V40;
    @Deprecated
    public static final EPredefinedProcessIdentifier BIS3A;
    public static final EPredefinedProcessIdentifier BIS03A_V20;
    @Deprecated
    public static final EPredefinedProcessIdentifier BIS4A;
    public static final EPredefinedProcessIdentifier BIS4A_V20;
    @Deprecated
    public static final EPredefinedProcessIdentifier BIS5A;
    public static final EPredefinedProcessIdentifier BIS5A_V20;
    @Deprecated
    public static final EPredefinedProcessIdentifier BIS6A;
    public static final EPredefinedProcessIdentifier BIS28A;
    public static final EPredefinedProcessIdentifier BIS30A;
    public static final EPredefinedProcessIdentifier BIS36A;
    private final String m_sID;
    private final String m_sBISID;
    private final EPredefinedDocumentTypeIdentifier[] m_aDocIDs;
    private final Version m_aSince;

    private EPredefinedProcessIdentifier(@Nonnull @Nonempty String string2, @Nonnull String string3, EPredefinedDocumentTypeIdentifier[] ePredefinedDocumentTypeIdentifierArray, Version version) {
        this.m_sID = string2;
        this.m_sBISID = string3;
        this.m_aDocIDs = ePredefinedDocumentTypeIdentifierArray;
        this.m_aSince = version;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getScheme() {
        return "cenbii-procid-ubl";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getBISID() {
        return this.m_sBISID;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends IPeppolPredefinedDocumentTypeIdentifier> getDocumentTypeIdentifiers() {
        return CollectionHelper.newList((Object[])this.m_aDocIDs);
    }

    @Override
    @Nonnull
    public PeppolProcessIdentifier getAsProcessIdentifier() {
        return new PeppolProcessIdentifier(this);
    }

    @Override
    @Nonnull
    public Version getSince() {
        return this.m_aSince;
    }

    public boolean isDefaultScheme() {
        return true;
    }

    @Nullable
    public static EPredefinedProcessIdentifier getFromProcessIdentifierOrNull(@Nullable IProcessIdentifier iProcessIdentifier) {
        if (iProcessIdentifier != null && iProcessIdentifier.hasScheme("cenbii-procid-ubl")) {
            for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
                if (!ePredefinedProcessIdentifier.getValue().equals(iProcessIdentifier.getValue())) continue;
                return ePredefinedProcessIdentifier;
            }
        }
        return null;
    }

    static {
        BIS1A = urn_www_cenbii_eu_profile_bii01_ver1_0;
        BIS1A_V40 = urn_www_cenbii_eu_profile_bii01_ver2_0;
        BIS3A = urn_www_cenbii_eu_profile_bii03_ver1_0;
        BIS03A_V20 = urn_www_cenbii_eu_profile_bii03_ver2_0;
        BIS4A = urn_www_cenbii_eu_profile_bii04_ver1_0;
        BIS4A_V20 = urn_www_cenbii_eu_profile_bii04_ver2_0;
        BIS5A = urn_www_cenbii_eu_profile_bii05_ver1_0;
        BIS5A_V20 = urn_www_cenbii_eu_profile_bii05_ver2_0;
        BIS6A = urn_www_cenbii_eu_profile_bii06_ver1_0;
        BIS28A = urn_www_cenbii_eu_profile_bii28_ver2_0;
        BIS30A = urn_www_cenbii_eu_profile_bii30_ver2_0;
        BIS36A = urn_www_cenbii_eu_profile_bii36_ver2_0;
    }
}

