/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.process;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.ProcessIdentifierType;
import com.helger.peppol.identifier.generic.process.IProcessIdentifier;
import com.helger.peppol.identifier.peppol.process.IMutablePeppolProcessIdentifier;
import com.helger.peppol.identifier.peppol.process.IPeppolProcessIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PeppolProcessIdentifier
extends ProcessIdentifierType
implements IMutablePeppolProcessIdentifier,
Comparable<PeppolProcessIdentifier>,
ICloneable<PeppolProcessIdentifier> {
    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolProcessIdentifier(@Nonnull IProcessIdentifier iProcessIdentifier) {
        this(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @Nonnull
    private static String _verifyScheme(@Nullable String string) {
        if (!IPeppolProcessIdentifier.isValidScheme(string)) {
            throw new IllegalArgumentException("Peppol Process identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull String string) {
        if (!IPeppolProcessIdentifier.isValidValue(string)) {
            throw new IllegalArgumentException("Peppol Process identifier value '" + string + "' is invalid!");
        }
        return string;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolProcessIdentifier(@Nonnull String string, @Nonnull String string2) {
        this(true, PeppolProcessIdentifier._verifyScheme(string), PeppolProcessIdentifier._verifyValue(string2));
    }

    protected PeppolProcessIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public int compareTo(@Nonnull PeppolProcessIdentifier peppolProcessIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolProcessIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolProcessIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolProcessIdentifier getClone() {
        return new PeppolProcessIdentifier(this);
    }

    @Nonnull
    @Deprecated
    public static PeppolProcessIdentifier createWithDefaultScheme(@Nonnull String string) {
        return new PeppolProcessIdentifier("cenbii-procid-ubl", string);
    }

    @Nonnull
    @Deprecated
    public static PeppolProcessIdentifier createFromURIPart(@Nonnull String string) throws IllegalArgumentException {
        PeppolProcessIdentifier peppolProcessIdentifier = PeppolProcessIdentifier.createFromURIPartOrNull(string);
        if (peppolProcessIdentifier == null) {
            throw new IllegalArgumentException("Peppol Process identifier '" + string + "' did not include correct delimiter: " + "::");
        }
        return peppolProcessIdentifier;
    }

    @Nullable
    @Deprecated
    public static PeppolProcessIdentifier createFromURIPartOrNull(@Nullable String string) {
        if (string == null) {
            return null;
        }
        ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return null;
        }
        return PeppolProcessIdentifier.createIfValid((String)iCommonsList.get(0), (String)iCommonsList.get(1));
    }

    @Nullable
    public static PeppolProcessIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (IPeppolProcessIdentifier.isValidScheme(string) && IPeppolProcessIdentifier.isValidValue(string2)) {
            return new PeppolProcessIdentifier(true, string, string2);
        }
        return null;
    }

    @Deprecated
    public static boolean isValidURIPart(@Nullable String string) {
        return PeppolProcessIdentifier.createFromURIPartOrNull(string) != null;
    }
}

