/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.process;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.peppol.identifier.peppol.process.EPredefinedProcessIdentifier;
import com.helger.peppol.identifier.peppol.process.IPeppolPredefinedProcessIdentifier;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PredefinedProcessIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedProcessIdentifier> s_aCodes = new CommonsHashMap();
    private static final PredefinedProcessIdentifierManager s_aInstance;

    private PredefinedProcessIdentifierManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsCollection<IPeppolPredefinedProcessIdentifier> getAllProcessIdentifiers() {
        return s_aCodes.copyOfValues();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllProcessIdentifierIDs() {
        return s_aCodes.copyOfKeySet();
    }

    @Nullable
    public static IPeppolPredefinedProcessIdentifier getProcessIdentifierOfID(@Nullable String string) {
        if (string != null) {
            for (Map.Entry entry : s_aCodes.entrySet()) {
                if (!string.equals(entry.getKey())) continue;
                return (IPeppolPredefinedProcessIdentifier)entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsProcessIdentifierWithID(@Nullable String string) {
        return PredefinedProcessIdentifierManager.getProcessIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
            s_aCodes.put((Object)ePredefinedProcessIdentifier.getValue(), (Object)ePredefinedProcessIdentifier);
        }
        s_aInstance = new PredefinedProcessIdentifierManager();
    }
}

