/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.validator;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.peppol.identifier.peppol.participant.IPeppolParticipantIdentifier;
import com.helger.peppol.identifier.peppol.validator.IParticipantIdentifierValidatorSPI;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class IdentifierValidator {
    private static final Logger s_aLogger = LoggerFactory.getLogger(IdentifierValidator.class);
    private static final ICommonsList<IParticipantIdentifierValidatorSPI> s_aParticipantIDValidators = ServiceLoaderHelper.getAllSPIImplementations(IParticipantIdentifierValidatorSPI.class);
    private static final IdentifierValidator s_aInstance;

    private IdentifierValidator() {
    }

    public static boolean isValidParticipantIdentifier(@Nonnull IPeppolParticipantIdentifier iPeppolParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iPeppolParticipantIdentifier, (String)"ParticipantID");
        if (!iPeppolParticipantIdentifier.hasDefaultScheme()) {
            return true;
        }
        boolean bl = false;
        String string = iPeppolParticipantIdentifier.getIssuingAgencyID();
        String string2 = iPeppolParticipantIdentifier.getLocalParticipantID();
        for (IParticipantIdentifierValidatorSPI iParticipantIdentifierValidatorSPI : s_aParticipantIDValidators) {
            if (!iParticipantIdentifierValidatorSPI.isSupportedIssuingAgency(string)) continue;
            if (iParticipantIdentifierValidatorSPI.isValueValid(string2)) {
                return true;
            }
            bl = true;
        }
        return !bl;
    }

    static {
        if (s_aParticipantIDValidators.isNotEmpty()) {
            s_aLogger.info("Loaded " + s_aParticipantIDValidators.size() + " SPI implementations of IParticipantIdentifierValidatorSPI");
        }
        s_aInstance = new IdentifierValidator();
    }
}

