/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.identifier.peppol.validator;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.peppol.issuingagency.EPredefinedIdentifierIssuingAgency;
import com.helger.peppol.identifier.peppol.validator.IParticipantIdentifierValidatorSPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@IsSPIImplementation
public final class ParticipantIdentifierValidatorNorwayOrgNumber
implements IParticipantIdentifierValidatorSPI {
    private static final int[] WEIGHTS = new int[]{3, 2, 7, 6, 5, 4, 3, 2};

    @Override
    public boolean isSupportedIssuingAgency(@Nonnull @Nonempty String string) {
        return EPredefinedIdentifierIssuingAgency.NO_ORGNR.getISO6523Code().equals(string) || EPredefinedIdentifierIssuingAgency.NO_VAT.getISO6523Code().equals(string);
    }

    @Override
    public boolean isValueValid(@Nonnull @Nonempty String string) {
        return ParticipantIdentifierValidatorNorwayOrgNumber.isValidOrganisationNumber(string);
    }

    public static boolean isValidOrganisationNumber(@Nullable String string) {
        int n;
        int n2;
        if (StringHelper.getLength((CharSequence)string) != 9) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isDigit(cArray[8])) {
            return false;
        }
        int n3 = cArray[8] - 48;
        int n4 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            n = cArray[n2];
            if (!Character.isDigit((char)n)) {
                return false;
            }
            int n5 = n - 48;
            n4 += n5 * WEIGHTS[n2];
        }
        n2 = n4 % 11;
        if (n2 == 0 && n3 == 0) {
            return true;
        }
        n = 11 - n2;
        return n3 == n;
    }
}

