/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sml;

import com.helger.commons.string.StringParser;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.sml.SMLInfo;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SMLInfoMicroTypeConverter
implements IMicroTypeConverter {
    private static final String ATTR_ID = "id";
    private static final String ATTR_DISPLAY_NAME = "displayname";
    private static final String ELEMENT_DNS_ZONE = "dnszone";
    private static final String ELEMENT_MANAGEMENT_SERVICE = "mgmtsvc";
    private static final String ATTR_REQUIRES_CLIENT_CERT = "clientcert";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Object object, @Nullable String string, @Nonnull String string2) {
        ISMLInfo iSMLInfo = (ISMLInfo)object;
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, (String)iSMLInfo.getID());
        microElement.setAttribute(ATTR_DISPLAY_NAME, iSMLInfo.getDisplayName());
        microElement.appendElement(string, ELEMENT_DNS_ZONE).appendText((CharSequence)iSMLInfo.getDNSZone());
        microElement.appendElement(string, ELEMENT_MANAGEMENT_SERVICE).appendText((CharSequence)iSMLInfo.getManagementServiceURL());
        microElement.setAttribute(ATTR_REQUIRES_CLIENT_CERT, iSMLInfo.isClientCertificateRequired());
        return microElement;
    }

    @Nonnull
    public SMLInfo convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        String string2 = iMicroElement.getAttributeValue(ATTR_DISPLAY_NAME);
        String string3 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_DNS_ZONE);
        String string4 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_MANAGEMENT_SERVICE);
        boolean bl = StringParser.parseBool((String)iMicroElement.getAttributeValue(ATTR_REQUIRES_CLIENT_CERT), (boolean)true);
        return new SMLInfo(string, string2, string3, string4, bl);
    }
}

