/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smp;

import com.helger.commons.string.StringHelper;
import com.helger.peppol.smp.ExtensionType;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeDocType;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Immutable
public final class SMPExtensionConverter {
    private static final XMLWriterSettings s_aXWS = new XMLWriterSettings().setSerializeDocType(EXMLSerializeDocType.IGNORE).setIndent(EXMLSerializeIndent.NONE);
    private static final SMPExtensionConverter s_aInstance = new SMPExtensionConverter();

    private SMPExtensionConverter() {
    }

    @Nullable
    public static String convertToString(@Nullable ExtensionType extensionType) {
        if (extensionType != null && extensionType.getAny() != null) {
            return XMLWriter.getNodeAsString((Node)extensionType.getAny(), (IXMLWriterSettings)s_aXWS);
        }
        return null;
    }

    @Nullable
    public static ExtensionType convert(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            try {
                Document document = DOMReader.readXMLDOM((String)string);
                if (document != null) {
                    ExtensionType extensionType = new ExtensionType();
                    extensionType.setAny(document.getDocumentElement());
                    return extensionType;
                }
            }
            catch (SAXException sAXException) {
                throw new IllegalArgumentException("Error in parsing extension XML '" + string + "'", sAXException);
            }
        }
        return null;
    }

    @Nullable
    public static ExtensionType convertOrNull(@Nullable String string) {
        try {
            return SMPExtensionConverter.convert(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

