/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.peppol.smp.ISMPTransportProfile;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SMPTransportProfile
implements ISMPTransportProfile,
ICloneable<SMPTransportProfile> {
    public static final ObjectType OT = new ObjectType("smp.transport.profile");
    public static final boolean DEFAULT_DEPRECATED = false;
    private final String m_sID;
    private String m_sName;
    private boolean m_bIsDeprecated;

    public SMPTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        this(iSMPTransportProfile.getID(), iSMPTransportProfile.getName(), iSMPTransportProfile.isDeprecated());
    }

    public SMPTransportProfile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this(string, string2, false);
    }

    public SMPTransportProfile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, boolean bl) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.setName(string2);
        this.setDeprecated(bl);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean isDeprecated() {
        return this.m_bIsDeprecated;
    }

    @Nonnull
    public final EChange setDeprecated(boolean bl) {
        if (bl == this.m_bIsDeprecated) {
            return EChange.UNCHANGED;
        }
        this.m_bIsDeprecated = bl;
        return EChange.CHANGED;
    }

    @Nonnull
    public SMPTransportProfile getClone() {
        return new SMPTransportProfile(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMPTransportProfile sMPTransportProfile = (SMPTransportProfile)object;
        return this.m_sID.equals(sMPTransportProfile.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Name", (Object)this.m_sName).append("Deprecated", this.m_bIsDeprecated).getToString();
    }
}

