/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.Base32Codec;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.url.IPeppolURLProvider;
import com.helger.peppol.utils.NAPTRResolver;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.xbill.DNS.TextParseException;

@ThreadSafe
public class EsensURLProvider
implements IPeppolURLProvider {
    public static final EsensURLProvider MUTABLE_INSTANCE = new EsensURLProvider();
    public static final IPeppolURLProvider INSTANCE = MUTABLE_INSTANCE;
    public static final Charset URL_CHARSET = StandardCharsets.UTF_8;
    public static final Locale URL_LOCALE = Locale.US;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private boolean m_bLowercaseValueBeforeHashing = true;
    private final ICommonsMap<String, String> m_aDNSCache = new CommonsHashMap();
    private boolean m_bUseDNSCache = true;

    public boolean isLowercaseValueBeforeHashing() {
        return this.m_aRWLock.readLocked(() -> this.m_bLowercaseValueBeforeHashing);
    }

    public void setLowercaseValueBeforeHashing(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bLowercaseValueBeforeHashing = bl;
            return this.m_bLowercaseValueBeforeHashing;
        });
    }

    public boolean isUseDNSCache() {
        return this.m_aRWLock.readLocked(() -> this.m_bUseDNSCache);
    }

    public void setUseDNSCache(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bUseDNSCache = bl;
            return this.m_bUseDNSCache;
        });
    }

    public void clearDNSCache() {
        this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.clear());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllCacheEntries() {
        return (ICommonsMap)this.m_aRWLock.readLocked(() -> (ICommonsMap)this.m_aDNSCache.getClone());
    }

    public void addCacheEntries(@Nullable Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.putAll(map));
        }
    }

    @Nonnull
    public static String getHashValueStringRepresentation(@Nonnull String string) {
        byte[] byArray = MessageDigestValue.create((byte[])string.getBytes(URL_CHARSET), (EMessageDigestAlgorithm)EMessageDigestAlgorithm.SHA_256).getAllDigestBytes();
        return new Base32Codec().setAddPaddding(false).getEncodedAsString(byArray, StandardCharsets.ISO_8859_1);
    }

    @Override
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) {
        return this.getDNSNameOfParticipant(iParticipantIdentifier, string, true);
    }

    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string, boolean bl) {
        return this.getDNSNameOfParticipant(iParticipantIdentifier, string, bl, "ns1lux.europa.eu");
    }

    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string, boolean bl, @Nullable String string2) {
        String string3;
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        if (StringHelper.hasText((String)string) && !StringHelper.endsWith((CharSequence)string, (char)'.')) {
            throw new IllegalArgumentException("if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = iParticipantIdentifier.getValue();
        if (this.m_bLowercaseValueBeforeHashing) {
            string4 = string4.toLowerCase(URL_LOCALE);
        }
        stringBuilder.append(EsensURLProvider.getHashValueStringRepresentation(string4)).append('.');
        if (iParticipantIdentifier.hasScheme()) {
            string3 = iParticipantIdentifier.getScheme();
            if (this.m_bLowercaseValueBeforeHashing) {
                string3 = string3.toLowerCase(URL_LOCALE);
            }
            stringBuilder.append(string3).append('.');
        }
        if (StringHelper.hasText((String)string)) {
            stringBuilder.append(string);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        string3 = stringBuilder.toString();
        if (!bl) {
            return string3;
        }
        boolean bl2 = this.isUseDNSCache();
        try {
            String string5;
            String string6 = string5 = bl2 ? (String)this.m_aRWLock.readLocked(() -> (String)this.m_aDNSCache.get((Object)string3)) : null;
            if (string5 == null) {
                string5 = NAPTRResolver.resolveFromNAPTR(string3, string2);
                if (string5 == null) {
                    throw new IllegalArgumentException("Failed to resolve '" + string3 + "'");
                }
                string5 = StringHelper.trimStart((String)string5, (String)"http://");
                string5 = StringHelper.trimStart((String)string5, (String)"https://");
                if (bl2) {
                    String string7 = string5;
                    this.m_aRWLock.writeLocked(() -> (String)this.m_aDNSCache.put((Object)string3, (Object)string7));
                }
            }
            return string5;
        }
        catch (TextParseException textParseException) {
            throw new IllegalStateException("Failed to parse '" + string3 + "'", textParseException);
        }
    }
}

