/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.url;

import com.helger.commons.ValueEnforcer;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.sml.ISMLInfo;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPeppolURLProvider
extends Serializable {
    @Nonnull
    default public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
        return this.getDNSNameOfParticipant(iParticipantIdentifier, iSMLInfo.getDNSZone());
    }

    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier var1, @Nullable String var2);

    @Nonnull
    default public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
        return this.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo.getDNSZone());
    }

    @Nonnull
    default public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        String string2 = "http://" + this.getDNSNameOfParticipant(iParticipantIdentifier, string);
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Error building SMP URI from string '" + string2 + "'", uRISyntaxException);
        }
    }

    @Nonnull
    default public URL getSMPURLOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
        return this.getSMPURLOfParticipant(iParticipantIdentifier, iSMLInfo.getDNSZone());
    }

    @Nonnull
    default public URL getSMPURLOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        URI uRI = this.getSMPURIOfParticipant(iParticipantIdentifier, string);
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Error building SMP URL from URI: " + uRI, malformedURLException);
        }
    }
}

