/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

@Immutable
public final class NAPTRResolver {
    private static final Logger s_aLogger = LoggerFactory.getLogger(NAPTRResolver.class);

    private NAPTRResolver() {
    }

    @Nullable
    private static String _getAppliedNAPTRRegEx(@Nonnull String string, @Nonnull String string2) {
        char c = string.charAt(0);
        int n = string.indexOf(c, 1);
        if (n < 0) {
            return null;
        }
        String string3 = string.substring(1, n);
        int n2 = string.indexOf(c, n + 1);
        if (n2 < 0) {
            return null;
        }
        String string4 = string.substring(n + 1, n2);
        String string5 = string.substring(n2 + 1);
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("NAPTR regex: '" + string3 + "' - '" + string4 + "' - '" + string5 + "'");
        }
        int n3 = "i".equalsIgnoreCase(string5) ? 2 : 0;
        String string6 = RegExHelper.stringReplacePattern((String)string3, (int)n3, (String)string2, (String)string4);
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("  NAPTR replacement: '" + string2 + "' -> '" + string6 + "'");
        }
        return string6;
    }

    @Nullable
    public static String resolveFromNAPTR(@Nullable String string, @Nullable String string2) throws TextParseException {
        ExtendedResolver extendedResolver;
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        Lookup lookup = new Lookup(string, 35);
        if (StringHelper.hasText((String)string2)) {
            try {
                extendedResolver = new ExtendedResolver();
                extendedResolver.addResolver((Resolver)new SimpleResolver(string2));
                extendedResolver.addResolver(Lookup.getDefaultResolver());
                extendedResolver.setTimeout(4);
                lookup.setResolver((Resolver)extendedResolver);
            }
            catch (UnknownHostException unknownHostException) {
                s_aLogger.info("Failed to use specific name server '" + string2 + "'");
            }
        }
        do {
            extendedResolver = lookup.run();
        } while (lookup.getResult() == 2);
        if (lookup.getResult() != 0) {
            s_aLogger.warn("Error looking up '" + string + "': " + lookup.getErrorString());
            return null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object : extendedResolver) {
            NAPTRRecord nAPTRRecord3 = (NAPTRRecord)object;
            if (!"U".equalsIgnoreCase(nAPTRRecord3.getFlags()) || !"Meta:SMP".equals(nAPTRRecord3.getService())) continue;
            commonsArrayList.add((Object)nAPTRRecord3);
        }
        if (commonsArrayList.isEmpty()) {
            s_aLogger.warn("No matching DNS NAPTR records returned for '" + string + "'");
            return null;
        }
        commonsArrayList.sort((nAPTRRecord, nAPTRRecord2) -> {
            int n = nAPTRRecord.getOrder() - nAPTRRecord2.getOrder();
            if (n == 0) {
                n = nAPTRRecord.getPreference() - nAPTRRecord2.getPreference();
            }
            return n;
        });
        for (NAPTRRecord nAPTRRecord4 : commonsArrayList) {
            Object object;
            String string3 = nAPTRRecord4.getRegexp();
            if (StringHelper.getLength((CharSequence)string3) <= 3 || (object = NAPTRResolver._getAppliedNAPTRRegEx(string3, string)) == null) continue;
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Using '" + (String)object + "' for original DNS name '" + string + "'");
            }
            return object;
        }
        s_aLogger.warn("None of the matching DNS NAPTR records for '" + string + "' has a valid regular expression. Details: " + commonsArrayList);
        return null;
    }
}

