/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.EKeyStoreLoadError;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolKeyStoreHelper {
    public static final String TRUSTSTORE_PRODUCTION_CLASSPATH = "truststore/global-truststore.jks";
    public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca";
    public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca (peppol root ca)";
    public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca (peppol root ca)";
    public static final String TRUSTSTORE_PILOT_CLASSPATH = "truststore/pilot-truststore.jks";
    public static final String TRUSTSTORE_PILOT_ALIAS_ROOT = "peppol root test ca";
    public static final String TRUSTSTORE_PILOT_ALIAS_AP = "peppol access point test ca (peppol root test ca)";
    public static final String TRUSTSTORE_PILOT_ALIAS_SMP = "peppol service metadata publisher test ca (peppol root test ca)";
    public static final String TRUSTSTORE_COMPLETE_CLASSPATH = "truststore/complete-truststore.jks";
    public static final String TRUSTSTORE_PASSWORD = "peppol";
    private static final PeppolKeyStoreHelper s_aInstance = new PeppolKeyStoreHelper();

    private PeppolKeyStoreHelper() {
    }

    @Nullable
    private static String _getLoadError(@Nonnull EKeyStoreLoadError eKeyStoreLoadError, @Nullable String[] stringArray) {
        switch (eKeyStoreLoadError) {
            case KEYSTORE_NO_PATH: {
                return "No keystore path provided.";
            }
            case KEYSTORE_LOAD_ERROR_NON_EXISTING: {
                return TextHelper.getFormattedText((String)"Failed to locate keystore path ''{0}''. Technical details: {1}", (Object[])stringArray);
            }
            case KEYSTORE_INVALID_PASSWORD: {
                return TextHelper.getFormattedText((String)"Invalid password provided for keystore ''{0}''. Technical details: {1}", (Object[])stringArray);
            }
            case KEYSTORE_LOAD_ERROR_FORMAT_ERROR: {
                return TextHelper.getFormattedText((String)"Failed to load the keystore ''{0}'' - invalid format. Technical details: {1}", (Object[])stringArray);
            }
            case KEY_NO_ALIAS: {
                return "No alias for keystore entry provided.";
            }
            case KEY_NO_PASSWORD: {
                return "No alias for keystore entry provided.";
            }
            case KEY_INVALID_ALIAS: {
                return TextHelper.getFormattedText((String)"Failed to find alias ''{0}'' in keystore ''{1}''.", (Object[])stringArray);
            }
            case KEY_INVALID_TYPE: {
                return TextHelper.getFormattedText((String)"Alias ''{0}'' in keystore ''{1}'' has an invalid type. The effective technical type is {2}.", (Object[])stringArray);
            }
            case KEY_INVALID_PASSWORD: {
                return TextHelper.getFormattedText((String)"Invalid password provided for alias ''{0}'' in keystore ''{1}''. Technical details: {2}.", (Object[])stringArray);
            }
            case KEY_LOAD_ERROR: {
                return TextHelper.getFormattedText((String)"Generic error loading alias ''{0}'' in keystore ''{1}''. Technical details: {2}.", (Object[])stringArray);
            }
        }
        return "Unknown error: " + eKeyStoreLoadError;
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKeyStore loadedKeyStore) {
        if (loadedKeyStore == null || loadedKeyStore.isSuccess()) {
            return null;
        }
        return PeppolKeyStoreHelper._getLoadError(loadedKeyStore.getError(), loadedKeyStore.getErrorParams());
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKey<?> loadedKey) {
        if (loadedKey == null || loadedKey.isSuccess()) {
            return null;
        }
        return PeppolKeyStoreHelper._getLoadError(loadedKey.getError(), loadedKey.getErrorParams());
    }
}

