/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.PDBusinessEntityType;
import com.helger.pd.businesscard.PDIdentifierType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessCardType", propOrder={"participantIdentifier", "businessEntity"})
@CodingStyleguideUnaware
public class PDBusinessCardType
implements Serializable,
Cloneable {
    @XmlElement(name="ParticipantIdentifier", required=true)
    private PDIdentifierType participantIdentifier;
    @XmlElement(name="BusinessEntity")
    private List<PDBusinessEntityType> businessEntity;

    @Nullable
    public PDIdentifierType getParticipantIdentifier() {
        return this.participantIdentifier;
    }

    public void setParticipantIdentifier(@Nullable PDIdentifierType pDIdentifierType) {
        this.participantIdentifier = pDIdentifierType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PDBusinessEntityType> getBusinessEntity() {
        if (this.businessEntity == null) {
            this.businessEntity = new ArrayList<PDBusinessEntityType>();
        }
        return this.businessEntity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDBusinessCardType pDBusinessCardType = (PDBusinessCardType)object;
        if (!EqualsHelper.equals((Object)this.participantIdentifier, (Object)pDBusinessCardType.participantIdentifier)) {
            return false;
        }
        return EqualsHelper.equals(this.businessEntity, pDBusinessCardType.businessEntity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.participantIdentifier).append(this.businessEntity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("participantIdentifier", (Object)this.participantIdentifier).append("businessEntity", this.businessEntity).toString();
    }

    public void setBusinessEntity(@Nullable List<PDBusinessEntityType> list) {
        this.businessEntity = list;
    }

    public boolean hasBusinessEntityEntries() {
        return !this.getBusinessEntity().isEmpty();
    }

    public boolean hasNoBusinessEntityEntries() {
        return this.getBusinessEntity().isEmpty();
    }

    @Nonnegative
    public int getBusinessEntityCount() {
        return this.getBusinessEntity().size();
    }

    @Nullable
    public PDBusinessEntityType getBusinessEntityAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getBusinessEntity().get(n);
    }

    public void addBusinessEntity(@Nonnull PDBusinessEntityType pDBusinessEntityType) {
        this.getBusinessEntity().add(pDBusinessEntityType);
    }

    public void cloneTo(@Nonnull PDBusinessCardType pDBusinessCardType) {
        ArrayList<PDBusinessEntityType> arrayList = new ArrayList<PDBusinessEntityType>();
        for (PDBusinessEntityType pDBusinessEntityType : this.getBusinessEntity()) {
            arrayList.add(pDBusinessEntityType == null ? null : pDBusinessEntityType.clone());
        }
        pDBusinessCardType.businessEntity = arrayList;
        pDBusinessCardType.participantIdentifier = this.participantIdentifier == null ? null : this.participantIdentifier.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public PDBusinessCardType clone() {
        PDBusinessCardType pDBusinessCardType = new PDBusinessCardType();
        this.cloneTo(pDBusinessCardType);
        return pDBusinessCardType;
    }
}

