/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.PDContactType;
import com.helger.pd.businesscard.PDIdentifierType;
import com.helger.pd.businesscard.jaxb.Adapter1;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessEntityType", propOrder={"name", "countryCode", "geographicalInformation", "identifier", "websiteURI", "contact", "additionalInformation"})
@CodingStyleguideUnaware
public class PDBusinessEntityType
implements Serializable,
Cloneable {
    @XmlElement(name="Name", required=true)
    private String name;
    @XmlElement(name="CountryCode", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="token")
    private String countryCode;
    @XmlElement(name="GeographicalInformation")
    private String geographicalInformation;
    @XmlElement(name="Identifier")
    private List<PDIdentifierType> identifier;
    @XmlElement(name="WebsiteURI")
    @XmlSchemaType(name="anyURI")
    private List<String> websiteURI;
    @XmlElement(name="Contact")
    private List<PDContactType> contact;
    @XmlElement(name="AdditionalInformation")
    private String additionalInformation;
    @XmlAttribute(name="registrationDate")
    @XmlJavaTypeAdapter(value=Adapter1.class)
    @XmlSchemaType(name="date")
    private LocalDate registrationDate;

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(@Nullable String string) {
        this.countryCode = string;
    }

    @Nullable
    public String getGeographicalInformation() {
        return this.geographicalInformation;
    }

    public void setGeographicalInformation(@Nullable String string) {
        this.geographicalInformation = string;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PDIdentifierType> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<PDIdentifierType>();
        }
        return this.identifier;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<String> getWebsiteURI() {
        if (this.websiteURI == null) {
            this.websiteURI = new ArrayList<String>();
        }
        return this.websiteURI;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PDContactType> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<PDContactType>();
        }
        return this.contact;
    }

    @Nullable
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(@Nullable String string) {
        this.additionalInformation = string;
    }

    @Nullable
    public LocalDate getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(@Nullable LocalDate localDate) {
        this.registrationDate = localDate;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDBusinessEntityType pDBusinessEntityType = (PDBusinessEntityType)object;
        if (!EqualsHelper.equals((Object)this.name, (Object)pDBusinessEntityType.name)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.countryCode, (Object)pDBusinessEntityType.countryCode)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.geographicalInformation, (Object)pDBusinessEntityType.geographicalInformation)) {
            return false;
        }
        if (!EqualsHelper.equals(this.identifier, pDBusinessEntityType.identifier)) {
            return false;
        }
        if (!EqualsHelper.equals(this.websiteURI, pDBusinessEntityType.websiteURI)) {
            return false;
        }
        if (!EqualsHelper.equals(this.contact, pDBusinessEntityType.contact)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.additionalInformation, (Object)pDBusinessEntityType.additionalInformation)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.registrationDate, (Object)pDBusinessEntityType.registrationDate);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.name).append((Object)this.countryCode).append((Object)this.geographicalInformation).append(this.identifier).append(this.websiteURI).append(this.contact).append((Object)this.additionalInformation).append((Object)this.registrationDate).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("name", (Object)this.name).append("countryCode", (Object)this.countryCode).append("geographicalInformation", (Object)this.geographicalInformation).append("identifier", this.identifier).append("websiteURI", this.websiteURI).append("contact", this.contact).append("additionalInformation", (Object)this.additionalInformation).append("registrationDate", (Object)this.registrationDate).toString();
    }

    public void setIdentifier(@Nullable List<PDIdentifierType> list) {
        this.identifier = list;
    }

    public void setWebsiteURI(@Nullable List<String> list) {
        this.websiteURI = list;
    }

    public void setContact(@Nullable List<PDContactType> list) {
        this.contact = list;
    }

    public boolean hasIdentifierEntries() {
        return !this.getIdentifier().isEmpty();
    }

    public boolean hasNoIdentifierEntries() {
        return this.getIdentifier().isEmpty();
    }

    @Nonnegative
    public int getIdentifierCount() {
        return this.getIdentifier().size();
    }

    @Nullable
    public PDIdentifierType getIdentifierAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getIdentifier().get(n);
    }

    public void addIdentifier(@Nonnull PDIdentifierType pDIdentifierType) {
        this.getIdentifier().add(pDIdentifierType);
    }

    public boolean hasWebsiteURIEntries() {
        return !this.getWebsiteURI().isEmpty();
    }

    public boolean hasNoWebsiteURIEntries() {
        return this.getWebsiteURI().isEmpty();
    }

    @Nonnegative
    public int getWebsiteURICount() {
        return this.getWebsiteURI().size();
    }

    @Nullable
    public String getWebsiteURIAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getWebsiteURI().get(n);
    }

    public void addWebsiteURI(@Nonnull String string) {
        this.getWebsiteURI().add(string);
    }

    public boolean hasContactEntries() {
        return !this.getContact().isEmpty();
    }

    public boolean hasNoContactEntries() {
        return this.getContact().isEmpty();
    }

    @Nonnegative
    public int getContactCount() {
        return this.getContact().size();
    }

    @Nullable
    public PDContactType getContactAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getContact().get(n);
    }

    public void addContact(@Nonnull PDContactType pDContactType) {
        this.getContact().add(pDContactType);
    }

    public void cloneTo(@Nonnull PDBusinessEntityType pDBusinessEntityType) {
        pDBusinessEntityType.additionalInformation = this.additionalInformation;
        ArrayList<PDContactType> arrayList = new ArrayList<PDContactType>();
        for (PDContactType cloneable2 : this.getContact()) {
            arrayList.add(cloneable2 == null ? null : cloneable2.clone());
        }
        pDBusinessEntityType.contact = arrayList;
        pDBusinessEntityType.countryCode = this.countryCode;
        pDBusinessEntityType.geographicalInformation = this.geographicalInformation;
        ArrayList arrayList2 = new ArrayList();
        for (PDIdentifierType pDIdentifierType : this.getIdentifier()) {
            arrayList2.add(pDIdentifierType == null ? null : pDIdentifierType.clone());
        }
        pDBusinessEntityType.identifier = arrayList2;
        pDBusinessEntityType.name = this.name;
        pDBusinessEntityType.registrationDate = this.registrationDate;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : this.getWebsiteURI()) {
            arrayList3.add(string);
        }
        pDBusinessEntityType.websiteURI = arrayList3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PDBusinessEntityType clone() {
        PDBusinessEntityType pDBusinessEntityType = new PDBusinessEntityType();
        this.cloneTo(pDBusinessEntityType);
        return pDBusinessEntityType;
    }
}

