/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.PDBusinessCardType;
import com.helger.peppol.identifier.generic.doctype.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.generic.doctype.SimpleDocumentTypeIdentifier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PDExtendedBusinessCard {
    private final PDBusinessCardType m_aBusinessCard;
    private final ICommonsList<IDocumentTypeIdentifier> m_aDocumentTypeIDs = new CommonsArrayList();

    public PDExtendedBusinessCard(@Nonnull PDBusinessCardType pDBusinessCardType, @Nullable Iterable<? extends IDocumentTypeIdentifier> iterable) {
        this.m_aBusinessCard = (PDBusinessCardType)ValueEnforcer.notNull((Object)pDBusinessCardType, (String)"BusinessInfo");
        if (iterable != null) {
            for (IDocumentTypeIdentifier iDocumentTypeIdentifier : iterable) {
                if (iDocumentTypeIdentifier == null) continue;
                this.m_aDocumentTypeIDs.add((Object)new SimpleDocumentTypeIdentifier(iDocumentTypeIdentifier));
            }
        }
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public PDBusinessCardType getBusinessCard() {
        return this.m_aBusinessCard;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypeIDs() {
        return (ICommonsList)this.m_aDocumentTypeIDs.getClone();
    }

    @Nonnegative
    public int getDocumentTypeCount() {
        return this.m_aDocumentTypeIDs.size();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BusinessCard", (Object)this.m_aBusinessCard).append("DocTypeIDs", this.m_aDocumentTypeIDs).toString();
    }
}

