/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.settings;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.scope.singleton.AbstractGlobalSingleton;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDServerConfiguration
extends AbstractGlobalSingleton {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDServerConfiguration.class);
    private static final ConfigFile s_aConfigFile;

    @Deprecated
    @UsedViaReflection
    private PDServerConfiguration() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return s_aConfigFile;
    }

    @Nonnull
    public static ISettings getSettingsObject() {
        return s_aConfigFile.getSettings();
    }

    @Nullable
    public static String getGlobalDebug() {
        return s_aConfigFile.getAsString((Object)"global.debug");
    }

    @Nullable
    public static String getGlobalProduction() {
        return s_aConfigFile.getAsString((Object)"global.production");
    }

    @Nullable
    public static String getDataPath() {
        return s_aConfigFile.getAsString((Object)"webapp.datapath");
    }

    public static boolean isCheckFileAccess() {
        return s_aConfigFile.getAsBoolean((Object)"webapp.checkfileaccess", true);
    }

    public static boolean isTestVersion() {
        return s_aConfigFile.getAsBoolean((Object)"webapp.testversion", GlobalDebug.isDebugMode());
    }

    public static boolean isClientCertificateValidationActive() {
        return s_aConfigFile.getAsBoolean((Object)"indexer.clientcert.validation", true);
    }

    @Nullable
    public static String getClientCertIssuer() {
        return s_aConfigFile.getAsString((Object)"clientcert.issuer");
    }

    @Nullable
    public static String getClientCertIssuerAlternative() {
        return s_aConfigFile.getAsString((Object)"clientcert-alt.issuer");
    }

    @Nonnull
    public static String getTruststoreLocation() {
        return s_aConfigFile.getAsString((Object)"truststore.path", "truststore/global-truststore.jks");
    }

    @Nonnull
    public static String getTruststorePassword() {
        return s_aConfigFile.getAsString((Object)"truststore.password", "peppol");
    }

    @Nonnull
    public static String getTruststoreAlias() {
        return s_aConfigFile.getAsString((Object)"truststore.alias", "peppol service metadata publisher ca (peppol root ca)");
    }

    @Nullable
    public static String getTruststoreLocationAlternative() {
        return s_aConfigFile.getAsString((Object)"truststore-alt.path", "truststore/pilot-truststore.jks");
    }

    @Nullable
    public static String getTruststorePasswordAlternative() {
        return s_aConfigFile.getAsString((Object)"truststore-alt.password", "peppol");
    }

    @Nullable
    public static String getTruststoreAliasAlternative() {
        return s_aConfigFile.getAsString((Object)"truststore-alt.alias", "peppol service metadata publisher test ca (peppol root test ca)");
    }

    @Nonnegative
    public static int getReIndexMaxRetryHours() {
        int n = s_aConfigFile.getAsInt((Object)"reindex.maxretryhours", 24);
        if (n < 0) {
            throw new IllegalStateException("The reindex.maxretryhours property must be >= 0!");
        }
        return n;
    }

    @Nonnegative
    public static int getReIndexRetryMinutes() {
        int n = s_aConfigFile.getAsInt((Object)"reindex.retryminutes", 5);
        if (n <= 0) {
            throw new IllegalStateException("The reindex.retryminutes property must be > 0!");
        }
        return n;
    }

    @Nullable
    public static String getProxyHost() {
        return s_aConfigFile.getAsString((Object)"http.proxyHost");
    }

    public static int getProxyPort() {
        return s_aConfigFile.getAsInt((Object)"http.proxyPort", 0);
    }

    static {
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder().addPathFromSystemProperty("peppol.directory.server.properties.path").addPathFromSystemProperty("directory.server.properties.path").addPath("private-pd.properties").addPath("pd.properties");
        s_aConfigFile = configFileBuilder.build();
        if (s_aConfigFile.isRead()) {
            s_aLogger.info("Read PEPPOL Directory server properties from " + s_aConfigFile.getReadResource().getPath());
        } else {
            s_aLogger.warn("Failed to read PEPPOL Directory server properties from " + configFileBuilder.getAllPaths());
        }
    }
}

