/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v1;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.v1.PD1BusinessEntityType;
import com.helger.pd.businesscard.v1.PD1IdentifierType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessCardType", propOrder={"participantIdentifier", "businessEntity"})
@CodingStyleguideUnaware
public class PD1BusinessCardType
implements Serializable,
Cloneable {
    @XmlElement(name="ParticipantIdentifier", required=true)
    private PD1IdentifierType participantIdentifier;
    @XmlElement(name="BusinessEntity")
    private List<PD1BusinessEntityType> businessEntity;

    @Nullable
    public PD1IdentifierType getParticipantIdentifier() {
        return this.participantIdentifier;
    }

    public void setParticipantIdentifier(@Nullable PD1IdentifierType pD1IdentifierType) {
        this.participantIdentifier = pD1IdentifierType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PD1BusinessEntityType> getBusinessEntity() {
        if (this.businessEntity == null) {
            this.businessEntity = new ArrayList<PD1BusinessEntityType>();
        }
        return this.businessEntity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PD1BusinessCardType pD1BusinessCardType = (PD1BusinessCardType)object;
        if (!EqualsHelper.equals((Object)this.participantIdentifier, (Object)pD1BusinessCardType.participantIdentifier)) {
            return false;
        }
        return EqualsHelper.equals(this.businessEntity, pD1BusinessCardType.businessEntity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.participantIdentifier).append(this.businessEntity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("participantIdentifier", (Object)this.participantIdentifier).append("businessEntity", this.businessEntity).getToString();
    }

    public void setBusinessEntity(@Nullable List<PD1BusinessEntityType> list) {
        this.businessEntity = list;
    }

    public boolean hasBusinessEntityEntries() {
        return !this.getBusinessEntity().isEmpty();
    }

    public boolean hasNoBusinessEntityEntries() {
        return this.getBusinessEntity().isEmpty();
    }

    @Nonnegative
    public int getBusinessEntityCount() {
        return this.getBusinessEntity().size();
    }

    @Nullable
    public PD1BusinessEntityType getBusinessEntityAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getBusinessEntity().get(n);
    }

    public void addBusinessEntity(@Nonnull PD1BusinessEntityType pD1BusinessEntityType) {
        this.getBusinessEntity().add(pD1BusinessEntityType);
    }

    public void cloneTo(@Nonnull PD1BusinessCardType pD1BusinessCardType) {
        ArrayList<PD1BusinessEntityType> arrayList = new ArrayList<PD1BusinessEntityType>();
        for (PD1BusinessEntityType pD1BusinessEntityType : this.getBusinessEntity()) {
            arrayList.add(pD1BusinessEntityType == null ? null : pD1BusinessEntityType.clone());
        }
        pD1BusinessCardType.businessEntity = arrayList;
        pD1BusinessCardType.participantIdentifier = this.participantIdentifier == null ? null : this.participantIdentifier.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public PD1BusinessCardType clone() {
        PD1BusinessCardType pD1BusinessCardType = new PD1BusinessCardType();
        this.cloneTo(pD1BusinessCardType);
        return pD1BusinessCardType;
    }
}

