/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.function.IFunction;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.jaxb.AbstractJAXBMarshaller;
import com.helger.pd.businesscard.v1.PD1BusinessCardType;
import com.helger.pd.businesscard.v1.PD1BusinessEntityType;
import com.helger.pd.businesscard.v1.PD1IdentifierType;
import com.helger.pd.businesscard.v2.ObjectFactory;
import com.helger.pd.businesscard.v2.PD2BusinessCardType;
import com.helger.pd.businesscard.v2.PD2BusinessEntityType;
import com.helger.pd.businesscard.v2.PD2IdentifierType;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;

public class PD2BusinessCardMarshaller
extends AbstractJAXBMarshaller<PD2BusinessCardType> {
    public static final String BUSINESS_INFORMATION_NS_URI = ObjectFactory._BusinessCard_QNAME.getNamespaceURI();
    @CodingStyleguideUnaware
    public static final List<? extends IReadableResource> BUSINESS_CARD_XSDS = new CommonsArrayList((Object)new ClassPathResource("/schemas/peppol-directory-business-card-20161123.xsd")).getAsUnmodifiable();

    public PD2BusinessCardMarshaller() {
        super(PD2BusinessCardType.class, BUSINESS_CARD_XSDS, (IFunction & Serializable)pD2BusinessCardType -> new ObjectFactory().createBusinessCard((PD2BusinessCardType)pD2BusinessCardType));
    }

    @Nonnull
    private static PD1IdentifierType _getAsID1(@Nonnull PD2IdentifierType pD2IdentifierType) {
        PD1IdentifierType pD1IdentifierType = new PD1IdentifierType();
        pD1IdentifierType.setScheme(pD2IdentifierType.getScheme());
        pD1IdentifierType.setValue(pD2IdentifierType.getValue());
        return pD1IdentifierType;
    }

    @Nonnull
    public static PD1BusinessCardType getAsV1(@Nonnull PD2BusinessCardType pD2BusinessCardType) {
        ValueEnforcer.notNull((Object)pD2BusinessCardType, (String)"BusinessCard");
        PD1BusinessCardType pD1BusinessCardType = new PD1BusinessCardType();
        pD1BusinessCardType.setParticipantIdentifier(PD2BusinessCardMarshaller._getAsID1(pD2BusinessCardType.getParticipantIdentifier()));
        for (PD2BusinessEntityType pD2BusinessEntityType : pD2BusinessCardType.getBusinessEntity()) {
            PD1BusinessEntityType pD1BusinessEntityType = new PD1BusinessEntityType();
            pD1BusinessEntityType.setName(pD2BusinessEntityType.getName());
            pD1BusinessEntityType.setCountryCode(pD2BusinessEntityType.getCountryCode());
            pD1BusinessEntityType.setGeographicalInformation(pD2BusinessEntityType.getGeographicalInformation());
            for (PD2IdentifierType pD2IdentifierType : pD2BusinessEntityType.getIdentifier()) {
                pD1BusinessEntityType.addIdentifier(PD2BusinessCardMarshaller._getAsID1(pD2IdentifierType));
            }
            pD1BusinessEntityType.setRegistrationDate(pD2BusinessEntityType.getRegistrationDate());
            pD1BusinessCardType.addBusinessEntity(pD1BusinessEntityType);
        }
        return pD1BusinessCardType;
    }
}

