/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.charset.CCharset;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.pd.client.PDClientConfiguration;
import com.helger.peppol.identifier.IIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IdentifierHelper;
import com.helger.peppol.utils.KeyStoreHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.security.KeyStore;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDClient
implements Closeable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDClient.class);
    private final String m_sPDHost;
    private final String m_sPDIndexerURL;
    private HttpHost m_aProxy;
    private Credentials m_aProxyCredentials;
    private CloseableHttpClient m_aHttpClient;

    public PDClient(@Nonnull URI uRI) {
        ValueEnforcer.notNull((Object)uRI, (String)"PDHost");
        String string = uRI.toString();
        this.m_sPDHost = string.endsWith("/") ? string : string + '/';
        this.m_sPDIndexerURL = this.m_sPDHost + "indexer/1.0/";
    }

    @Nonnull
    public String getPDHostURI() {
        return this.m_sPDHost;
    }

    @Nullable
    public HttpHost getProxy() {
        return this.m_aProxy;
    }

    public void setProxy(@Nullable HttpHost httpHost) {
        this.m_aProxy = httpHost;
    }

    @Nullable
    public Credentials getProxyCredentials() {
        return this.m_aProxyCredentials;
    }

    public void setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aProxyCredentials = credentials;
    }

    protected HttpClientBuilder createClientBuilder() {
        try {
            KeyStore keyStore = KeyStoreHelper.loadKeyStore((String)PDClientConfiguration.getKeyStorePath(), (String)PDClientConfiguration.getKeyStorePassword());
            SSLContext sSLContext = SSLContexts.custom().loadKeyMaterial(keyStore, PDClientConfiguration.getKeyStoreKeyPassword(), new PrivateKeyStrategy(){

                public String chooseAlias(Map<String, PrivateKeyDetails> map, Socket socket) {
                    String string = PDClientConfiguration.getKeyStoreKeyAlias();
                    return map.containsKey(string) ? string : null;
                }
            }).build();
            SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sSLConnectionSocketFactory).build();
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(100);
            poolingHttpClientConnectionManager.setMaxTotal(200);
            poolingHttpClientConnectionManager.setValidateAfterInactivity(1000);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
            poolingHttpClientConnectionManager.setDefaultConnectionConfig(connectionConfig);
            return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init HTTP client", (Throwable)exception);
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected RequestConfig createRequestConfig() {
        return RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).setProxy(this.m_aProxy).build();
    }

    @Nonnull
    @OverrideOnDemand
    protected CloseableHttpResponse executeRequest(@Nonnull HttpRequestBase httpRequestBase) throws IOException {
        httpRequestBase.setConfig(this.createRequestConfig());
        HttpClientContext httpClientContext = HttpClientContext.create();
        if (this.m_aProxy != null && this.m_aProxyCredentials != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(this.m_aProxy), this.m_aProxyCredentials);
            httpClientContext.setCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        if (this.m_aHttpClient == null) {
            this.m_aHttpClient = this.createClientBuilder().build();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Executing request " + httpRequestBase.getRequestLine());
        }
        return this.m_aHttpClient.execute((HttpUriRequest)httpRequestBase, (HttpContext)httpClientContext);
    }

    @Nullable
    private static String _getResponseString(@Nonnull CloseableHttpResponse closeableHttpResponse) throws IOException {
        HttpEntity httpEntity = closeableHttpResponse.getEntity();
        String string = httpEntity == null ? null : StreamHelper.getAllBytesAsString((InputStream)httpEntity.getContent(), (Charset)CCharset.CHARSET_UTF_8_OBJ);
        EntityUtils.consume((HttpEntity)httpEntity);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public boolean isServiceGroupRegistered(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpGet httpGet = new HttpGet(this.m_sPDIndexerURL + IdentifierHelper.getIdentifierURIPercentEncoded((IIdentifier)iParticipantIdentifier));
        try (CloseableHttpResponse closeableHttpResponse = this.executeRequest((HttpRequestBase)httpGet);){
            String string = PDClient._getResponseString(closeableHttpResponse);
            if (closeableHttpResponse.getStatusLine().getStatusCode() >= 200 && closeableHttpResponse.getStatusLine().getStatusCode() < 300) {
                boolean bl = true;
                return bl;
            }
            if (closeableHttpResponse.getStatusLine().getStatusCode() == 404) {
                boolean bl = false;
                return bl;
            }
            s_aLogger.warn("Unexpected status returned from server for " + httpGet.getRequestLine() + ": " + closeableHttpResponse.getStatusLine() + "\n" + string);
            return false;
        }
        catch (IOException iOException) {
            s_aLogger.error("Error performing request " + httpGet.getRequestLine(), (Throwable)iOException);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public ESuccess addServiceGroupToIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        String string = IdentifierHelper.getIdentifierURIEncoded((IIdentifier)iParticipantIdentifier);
        HttpPut httpPut = new HttpPut(this.m_sPDIndexerURL);
        httpPut.setEntity((HttpEntity)new StringEntity(string, CCharset.CHARSET_UTF_8_OBJ));
        try (CloseableHttpResponse closeableHttpResponse = this.executeRequest((HttpRequestBase)httpPut);){
            String string2 = PDClient._getResponseString(closeableHttpResponse);
            if (closeableHttpResponse.getStatusLine().getStatusCode() >= 200 && closeableHttpResponse.getStatusLine().getStatusCode() < 300) {
                s_aLogger.info("Added service group '" + string + "' to PEPPOL Directory index. May take some time until it shows up.");
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            s_aLogger.warn("Unexpected status returned from server for " + httpPut.getRequestLine() + ": " + closeableHttpResponse.getStatusLine() + "\n" + string2);
            return ESuccess.FAILURE;
        }
        catch (IOException iOException) {
            s_aLogger.error("Error performing request " + httpPut.getRequestLine(), (Throwable)iOException);
        }
        return ESuccess.FAILURE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public ESuccess deleteServiceGroupFromIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpDelete httpDelete = new HttpDelete(this.m_sPDIndexerURL + IdentifierHelper.getIdentifierURIPercentEncoded((IIdentifier)iParticipantIdentifier));
        try (CloseableHttpResponse closeableHttpResponse = this.executeRequest((HttpRequestBase)httpDelete);){
            String string = PDClient._getResponseString(closeableHttpResponse);
            if (closeableHttpResponse.getStatusLine().getStatusCode() >= 200 && closeableHttpResponse.getStatusLine().getStatusCode() < 300) {
                String string2 = IdentifierHelper.getIdentifierURIEncoded((IIdentifier)iParticipantIdentifier);
                s_aLogger.info("Removed service group '" + string2 + "' from PEPPOL Directory index. May take some time until it is removed.");
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            s_aLogger.warn("Unexpected status returned from server for " + httpDelete.getRequestLine() + ": " + closeableHttpResponse.getStatusLine() + "\n" + string);
            return ESuccess.FAILURE;
        }
        catch (IOException iOException) {
            s_aLogger.error("Error performing request " + httpDelete.getRequestLine(), (Throwable)iOException);
        }
        return ESuccess.FAILURE;
    }

    @Override
    public void close() throws IOException {
        if (this.m_aHttpClient != null) {
            this.m_aHttpClient.close();
        }
    }

    @Nonnull
    public static PDClient createDefaultClient() {
        PDClient pDClient = new PDClient(URI.create("http://pyp.helger.com"));
        boolean bl = pDClient.getPDHostURI().startsWith("http:");
        String string = bl ? "http." : "https.";
        String string2 = PDClientConfiguration.getConfigFile().getString(string + "proxyHost");
        int n = PDClientConfiguration.getConfigFile().getInt(string + "proxyPort", 0);
        if (string2 != null && n > 0) {
            pDClient.setProxy(new HttpHost(string2, n));
        }
        return pDClient;
    }
}

