/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.peppol.utils.ConfigFile;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDClientConfiguration {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDClientConfiguration.class);
    private static final ConfigFile s_aConfigFile;

    private PDClientConfiguration() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return s_aConfigFile;
    }

    @Nullable
    public static String getKeyStorePath() {
        return s_aConfigFile.getString("keystore.path");
    }

    @Nullable
    public static String getKeyStorePassword() {
        return s_aConfigFile.getString("keystore.password");
    }

    @Nullable
    public static String getKeyStoreKeyAlias() {
        return s_aConfigFile.getString("keystore.key.alias");
    }

    @Nullable
    public static char[] getKeyStoreKeyPassword() {
        return s_aConfigFile.getCharArray("keystore.key.password");
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = SystemProperties.getPropertyValue((String)"peppol.pd.client.properties.path");
        if (StringHelper.hasText((String)string)) {
            arrayList.add(string);
        }
        if (StringHelper.hasText((String)(string = SystemProperties.getPropertyValue((String)"pd.client.properties.path")))) {
            arrayList.add(string);
        }
        arrayList.add("private-pd-client.properties");
        arrayList.add("pd-client.properties");
        s_aConfigFile = new ConfigFile((String[])ArrayHelper.newArray(arrayList, String.class));
        if (s_aConfigFile.isRead()) {
            s_aLogger.info("Read PEPPOL Directory client properties from " + s_aConfigFile.getReadResource().getPath());
        } else {
            s_aLogger.warn("Failed to read PEPPOL Directory client properties from any of the paths: " + arrayList);
        }
    }
}

