/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.url.URLHelper;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.pd.client.PDClientConfiguration;
import com.helger.pd.client.PDClientResponseHandler;
import com.helger.pd.client.PDHttpClientFactory;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDClient
implements Closeable {
    public static final String PATH_INDEXER_10 = "indexer/1.0/";
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDClient.class);
    private final String m_sPDHost;
    private final String m_sPDIndexerURL;
    private HttpClientManager m_aHttpClientMgr = new HttpClientManager((IHttpClientProvider)new PDHttpClientFactory());
    private HttpHost m_aProxy;
    private Credentials m_aProxyCredentials;

    public PDClient(@Nonnull String string) {
        this(URLHelper.getAsURI((String)string));
    }

    public PDClient(@Nonnull URI uRI) {
        int n;
        ValueEnforcer.notNull((Object)uRI, (String)"PDHost");
        String string = uRI.toString();
        this.m_sPDHost = string.endsWith("/") ? string : string + '/';
        this.m_sPDIndexerURL = this.m_sPDHost + PATH_INDEXER_10;
        boolean bl = this.m_sPDHost.startsWith("http:");
        String string2 = bl ? PDClientConfiguration.getHttpProxyHost() : PDClientConfiguration.getHttpsProxyHost();
        int n2 = n = bl ? PDClientConfiguration.getHttpProxyPort() : PDClientConfiguration.getHttpsProxyPort();
        if (string2 != null && n > 0) {
            this.setProxy(new HttpHost(string2, n));
        }
    }

    @Override
    public void close() {
        StreamHelper.close((AutoCloseable)this.m_aHttpClientMgr);
    }

    @Nonnull
    public String getPDHostURI() {
        return this.m_sPDHost;
    }

    @Nullable
    public HttpHost getProxy() {
        return this.m_aProxy;
    }

    public final void setProxy(@Nullable HttpHost httpHost) {
        this.m_aProxy = httpHost;
    }

    @Nullable
    public Credentials getProxyCredentials() {
        return this.m_aProxyCredentials;
    }

    public void setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aProxyCredentials = credentials;
    }

    public void setHttpClientManager(@Nonnull HttpClientManager httpClientManager) {
        ValueEnforcer.notNull((Object)httpClientManager, (String)"HttpClientMgr");
        this.m_aHttpClientMgr = httpClientManager;
    }

    @Nonnull
    @OverrideOnDemand
    protected <T> T executeRequest(@Nonnull HttpRequestBase httpRequestBase, @Nonnull ResponseHandler<T> responseHandler) throws IOException {
        HttpContext httpContext = HttpClientHelper.createHttpContext((HttpHost)this.m_aProxy, (Credentials)this.m_aProxyCredentials);
        return (T)this.m_aHttpClientMgr.execute((HttpUriRequest)httpRequestBase, httpContext, responseHandler);
    }

    @Nonnull
    public boolean isServiceGroupRegistered(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpGet httpGet = new HttpGet(this.m_sPDIndexerURL + iParticipantIdentifier.getURIPercentEncoded());
        try {
            return this.executeRequest((HttpRequestBase)httpGet, new PDClientResponseHandler()).isSuccess();
        }
        catch (IOException iOException) {
            s_aLogger.info("isServiceGroupRegistered internal error", (Throwable)iOException);
            return false;
        }
    }

    @Nonnull
    public ESuccess addServiceGroupToIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        String string = iParticipantIdentifier.getURIEncoded();
        HttpPut httpPut = new HttpPut(this.m_sPDIndexerURL);
        httpPut.setEntity((HttpEntity)new StringEntity(string, StandardCharsets.UTF_8));
        try {
            if (this.executeRequest((HttpRequestBase)httpPut, new PDClientResponseHandler()).isSuccess()) {
                s_aLogger.info("Added service group '" + string + "' to PEPPOL Directory index. May take some time until it shows up.");
                return ESuccess.SUCCESS;
            }
        }
        catch (IOException iOException) {
            s_aLogger.info("addServiceGroupToIndex internal error", (Throwable)iOException);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public ESuccess deleteServiceGroupFromIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpDelete httpDelete = new HttpDelete(this.m_sPDIndexerURL + iParticipantIdentifier.getURIPercentEncoded());
        try {
            if (this.executeRequest((HttpRequestBase)httpDelete, new PDClientResponseHandler()).isSuccess()) {
                String string = iParticipantIdentifier.getURIEncoded();
                s_aLogger.info("Removed service group '" + string + "' from PEPPOL Directory index. May take some time until it is removed.");
                return ESuccess.SUCCESS;
            }
        }
        catch (IOException iOException) {
            s_aLogger.info("deleteServiceGroupFromIndex internal error", (Throwable)iOException);
        }
        return ESuccess.FAILURE;
    }
}

