/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDClientConfiguration {
    public static final String SYSTEM_PROPERTY_PRIMARY = "peppol.pd.client.properties.path";
    public static final String SYSTEM_PROPERTY_SECONDARY = "pd.client.properties.path";
    public static final String PROPERTY_FILE_PRIMARY = "private-pd-client.properties";
    public static final String PROPERTY_FILE_SECONDARY = "pd-client.properties";
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDClientConfiguration.class);
    private static final ConfigFile s_aConfigFile;

    private PDClientConfiguration() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return s_aConfigFile;
    }

    @Nullable
    public static String getKeyStorePath() {
        return s_aConfigFile.getAsString((Object)"keystore.path");
    }

    @Nullable
    public static String getKeyStorePassword() {
        return s_aConfigFile.getAsString((Object)"keystore.password");
    }

    @Nullable
    public static String getKeyStoreKeyAlias() {
        return s_aConfigFile.getAsString((Object)"keystore.key.alias");
    }

    @Nullable
    public static char[] getKeyStoreKeyPassword() {
        return s_aConfigFile.getAsCharArray((Object)"keystore.key.password");
    }

    @Nullable
    public static String getHttpProxyHost() {
        return s_aConfigFile.getAsString((Object)"http.proxyHost");
    }

    public static int getHttpProxyPort() {
        return s_aConfigFile.getAsInt((Object)"http.proxyPort", 0);
    }

    @Nullable
    public static String getHttpsProxyHost() {
        return s_aConfigFile.getAsString((Object)"https.proxyHost");
    }

    public static int getHttpsProxyPort() {
        return s_aConfigFile.getAsInt((Object)"https.proxyPort", 0);
    }

    static {
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder().addPathFromSystemProperty(SYSTEM_PROPERTY_PRIMARY).addPathFromSystemProperty(SYSTEM_PROPERTY_SECONDARY).addPath(PROPERTY_FILE_PRIMARY).addPath(PROPERTY_FILE_SECONDARY);
        s_aConfigFile = configFileBuilder.build();
        if (s_aConfigFile.isRead()) {
            s_aLogger.info("Read PEPPOL Directory client properties from " + s_aConfigFile.getReadResource().getPath());
        } else {
            s_aLogger.warn("Failed to read PEPPOL Directory client properties from " + configFileBuilder.getAllPaths());
        }
    }
}

