/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.random.VerySecureRandom;
import com.helger.commons.ws.HostnameVerifierVerifyAll;
import com.helger.httpclient.HttpClientFactory;
import com.helger.pd.client.PDClientConfiguration;
import com.helger.peppol.utils.PeppolKeyStoreHelper;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDHttpClientFactory
extends HttpClientFactory {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDHttpClientFactory.class);

    public PDHttpClientFactory() {
        this.setHostnameVerifier((HostnameVerifier)new HostnameVerifierVerifyAll(false));
    }

    @Nullable
    public SSLContext createSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        LoadedKeyStore loadedKeyStore = KeyStoreHelper.loadKeyStore((String)PDClientConfiguration.getKeyStorePath(), (String)PDClientConfiguration.getKeyStorePassword());
        if (loadedKeyStore.isFailure()) {
            s_aLogger.error("Failed to initialize keystore for service connection! Can only use http now! Details: " + PeppolKeyStoreHelper.getLoadError((LoadedKeyStore)loadedKeyStore));
            return null;
        }
        return SSLContexts.custom().loadKeyMaterial(loadedKeyStore.getKeyStore(), PDClientConfiguration.getKeyStoreKeyPassword(), (map, socket) -> {
            String string;
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("chooseAlias(" + map + ", " + socket + ")");
            }
            return map.containsKey(string = PDClientConfiguration.getKeyStoreKeyAlias()) ? string : null;
        }).loadTrustMaterial(null, (x509CertificateArray, string) -> {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("isTrusted(" + x509CertificateArray + ", " + string + ")");
            }
            return true;
        }).setSecureRandom(VerySecureRandom.getInstance()).build();
    }
}

