/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.pd.client.IPDClientExceptionCallback;
import com.helger.pd.client.PDClientConfiguration;
import com.helger.pd.client.PDClientResponseHandler;
import com.helger.pd.client.PDHttpClientFactory;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PDClient
implements Closeable {
    public static final String PATH_INDEXER_10 = "indexer/1.0/";
    private static final Logger LOGGER = LoggerFactory.getLogger(PDClient.class);
    private final String m_sPDHost;
    private final String m_sPDIndexerURL;
    private IPDClientExceptionCallback m_aExceptionHdl = PDClient._createDefaultExCb();
    private HttpClientManager m_aHttpClientMgr = new HttpClientManager((IHttpClientProvider)new PDHttpClientFactory());
    private HttpHost m_aProxy;
    private Credentials m_aProxyCredentials;

    @Nonnull
    private static IPDClientExceptionCallback _createDefaultExCb() {
        return (IPDClientExceptionCallback & Serializable)(iParticipantIdentifier, string, throwable) -> LOGGER.error("Internal error in " + string + " for " + iParticipantIdentifier.getURIEncoded(), throwable);
    }

    public PDClient(@Nonnull String string) {
        this(URLHelper.getAsURI((String)string));
    }

    public PDClient(@Nonnull URI uRI) {
        String string;
        int n;
        ValueEnforcer.notNull((Object)uRI, (String)"PDHost");
        String string2 = uRI.toString();
        this.m_sPDHost = string2.endsWith("/") ? string2 : string2 + '/';
        this.m_sPDIndexerURL = this.m_sPDHost + PATH_INDEXER_10;
        boolean bl = this.m_sPDHost.startsWith("http:");
        String string3 = bl ? PDClientConfiguration.getHttpProxyHost() : PDClientConfiguration.getHttpsProxyHost();
        int n2 = n = bl ? PDClientConfiguration.getHttpProxyPort() : PDClientConfiguration.getHttpsProxyPort();
        if (string3 != null && n > 0) {
            this.setProxy(new HttpHost(string3, n));
        }
        if (StringHelper.hasText((String)(string = PDClientConfiguration.getProxyUsername()))) {
            String string4 = PDClientConfiguration.getProxyPassword();
            this.setProxyCredentials((Credentials)new UsernamePasswordCredentials(string, string4));
        }
    }

    @Override
    public void close() {
        StreamHelper.close((AutoCloseable)this.m_aHttpClientMgr);
    }

    @Nonnull
    public IPDClientExceptionCallback getExceptionHandler() {
        return this.m_aExceptionHdl;
    }

    public void setExceptionHandler(@Nonnull IPDClientExceptionCallback iPDClientExceptionCallback) {
        ValueEnforcer.notNull((Object)iPDClientExceptionCallback, (String)"ExceptionHdl");
        this.m_aExceptionHdl = iPDClientExceptionCallback;
    }

    @Nonnull
    public String getPDHostURI() {
        return this.m_sPDHost;
    }

    @Nullable
    public HttpHost getProxy() {
        return this.m_aProxy;
    }

    public final void setProxy(@Nullable HttpHost httpHost) {
        this.m_aProxy = httpHost;
    }

    @Nullable
    public Credentials getProxyCredentials() {
        return this.m_aProxyCredentials;
    }

    public final void setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aProxyCredentials = credentials;
    }

    public void setHttpClientManager(@Nonnull HttpClientManager httpClientManager) {
        ValueEnforcer.notNull((Object)httpClientManager, (String)"HttpClientMgr");
        this.m_aHttpClientMgr = httpClientManager;
    }

    @Nonnull
    @OverrideOnDemand
    protected <T> T executeRequest(@Nonnull HttpRequestBase httpRequestBase, @Nonnull ResponseHandler<T> responseHandler) throws IOException {
        HttpContext httpContext = HttpClientHelper.createHttpContext((HttpHost)this.m_aProxy, (Credentials)this.m_aProxyCredentials);
        return (T)this.m_aHttpClientMgr.execute((HttpUriRequest)httpRequestBase, httpContext, responseHandler);
    }

    @Nonnull
    public boolean isServiceGroupRegistered(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpGet httpGet = new HttpGet(this.m_sPDIndexerURL + iParticipantIdentifier.getURIPercentEncoded());
        try {
            return this.executeRequest((HttpRequestBase)httpGet, new PDClientResponseHandler()).isSuccess();
        }
        catch (Throwable throwable) {
            this.m_aExceptionHdl.onException(iParticipantIdentifier, "isServiceGroupRegistered", throwable);
            return false;
        }
    }

    @Nonnull
    public ESuccess addServiceGroupToIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        String string = iParticipantIdentifier.getURIEncoded();
        HttpPut httpPut = new HttpPut(this.m_sPDIndexerURL);
        httpPut.setEntity((HttpEntity)new StringEntity(string, StandardCharsets.UTF_8));
        try {
            if (this.executeRequest((HttpRequestBase)httpPut, new PDClientResponseHandler()).isSuccess()) {
                LOGGER.info("Added service group '" + string + "' to PEPPOL Directory index. May take some time until it shows up.");
                return ESuccess.SUCCESS;
            }
        }
        catch (Throwable throwable) {
            this.m_aExceptionHdl.onException(iParticipantIdentifier, "addServiceGroupToIndex", throwable);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public ESuccess deleteServiceGroupFromIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpDelete httpDelete = new HttpDelete(this.m_sPDIndexerURL + iParticipantIdentifier.getURIPercentEncoded());
        try {
            if (this.executeRequest((HttpRequestBase)httpDelete, new PDClientResponseHandler()).isSuccess()) {
                String string = iParticipantIdentifier.getURIEncoded();
                LOGGER.info("Removed service group '" + string + "' from PEPPOL Directory index. May take some time until it is removed.");
                return ESuccess.SUCCESS;
            }
        }
        catch (Throwable throwable) {
            this.m_aExceptionHdl.onException(iParticipantIdentifier, "deleteServiceGroupFromIndex", throwable);
        }
        return ESuccess.FAILURE;
    }
}

