/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.security.keystore.EKeyStoreType;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDClientConfiguration {
    public static final String SYSTEM_PROPERTY_PRIMARY = "peppol.pd.client.properties.path";
    public static final String SYSTEM_PROPERTY_SECONDARY = "pd.client.properties.path";
    public static final String PROPERTY_FILE_PRIMARY = "private-pd-client.properties";
    public static final String PROPERTY_FILE_SECONDARY = "pd-client.properties";
    public static final EKeyStoreType DEFAULT_TRUSTSTORE_TYPE = EKeyStoreType.JKS;
    public static final String DEFAULT_TRUSTSTORE_PATH = "truststore/pd-client.truststore.jks";
    public static final String DEFAULT_TRUSTSTORE_PASSWORD = "peppol";
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PDClientConfiguration.class);
    private static final ConfigFile s_aConfigFile;

    private PDClientConfiguration() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return s_aConfigFile;
    }

    @Nonnull
    public static EKeyStoreType getKeyStoreType() {
        String string = s_aConfigFile.getAsString((Object)"keystore.type");
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)EKeyStoreType.JKS);
    }

    @Nullable
    public static String getKeyStorePath() {
        return s_aConfigFile.getAsString((Object)"keystore.path");
    }

    @Nullable
    public static String getKeyStorePassword() {
        return s_aConfigFile.getAsString((Object)"keystore.password");
    }

    @Nullable
    public static String getKeyStoreKeyAlias() {
        return s_aConfigFile.getAsString((Object)"keystore.key.alias");
    }

    @Nullable
    public static char[] getKeyStoreKeyPassword() {
        return s_aConfigFile.getAsCharArray((Object)"keystore.key.password");
    }

    @Nonnull
    public static EKeyStoreType getTrustStoreType() {
        String string = s_aConfigFile.getAsString((Object)"truststore.type");
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)DEFAULT_TRUSTSTORE_TYPE);
    }

    @Nullable
    public static String getTrustStorePath() {
        return s_aConfigFile.getAsString((Object)"truststore.path", DEFAULT_TRUSTSTORE_PATH);
    }

    @Nullable
    public static String getTrustStorePassword() {
        return s_aConfigFile.getAsString((Object)"truststore.password", DEFAULT_TRUSTSTORE_PASSWORD);
    }

    public static boolean isHttpsHostnameVerificationDisabled() {
        return s_aConfigFile.getAsBoolean((Object)"https.hostname-verification.disabled", true);
    }

    @Nullable
    public static String getHttpProxyHost() {
        return s_aConfigFile.getAsString((Object)"http.proxyHost");
    }

    public static int getHttpProxyPort() {
        return s_aConfigFile.getAsInt((Object)"http.proxyPort", 0);
    }

    @Nullable
    public static String getHttpsProxyHost() {
        return s_aConfigFile.getAsString((Object)"https.proxyHost");
    }

    public static int getHttpsProxyPort() {
        return s_aConfigFile.getAsInt((Object)"https.proxyPort", 0);
    }

    @Nullable
    public static String getProxyUsername() {
        return s_aConfigFile.getAsString((Object)"proxy.username");
    }

    @Nullable
    public static String getProxyPassword() {
        return s_aConfigFile.getAsString((Object)"proxy.password");
    }

    public static int getConnectTimeoutMS() {
        return s_aConfigFile.getAsInt((Object)"connect.timeout.ms", 5000);
    }

    public static int getRequestTimeoutMS() {
        return s_aConfigFile.getAsInt((Object)"request.timeout.ms", 10000);
    }

    static {
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder().addPathFromSystemProperty(SYSTEM_PROPERTY_PRIMARY).addPathFromSystemProperty(SYSTEM_PROPERTY_SECONDARY).addPath(PROPERTY_FILE_PRIMARY).addPath(PROPERTY_FILE_SECONDARY);
        s_aConfigFile = configFileBuilder.build();
        if (s_aConfigFile.isRead()) {
            LOGGER.info("Read PEPPOL Directory client properties from " + s_aConfigFile.getReadResource().getPath());
        } else {
            LOGGER.warn("Failed to read PEPPOL Directory client properties from " + configFileBuilder.getAllPaths());
        }
    }
}

