/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.state.ESuccess;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class PDClientResponseHandler
implements ResponseHandler<ESuccess> {
    @Nullable
    public ESuccess handleResponse(@Nonnull HttpResponse httpResponse) throws ClientProtocolException, IOException {
        Object object;
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
            return ESuccess.SUCCESS;
        }
        if (statusLine.getStatusCode() == 404) {
            return ESuccess.FAILURE;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        String string = null;
        if (httpEntity != null) {
            Charset charset;
            object = ContentType.get((HttpEntity)httpEntity);
            if (object == null) {
                object = ContentType.DEFAULT_TEXT;
            }
            if ((charset = object.getCharset()) == null) {
                charset = StandardCharsets.UTF_8;
            }
            string = EntityUtils.toString((HttpEntity)httpEntity, (Charset)charset);
        }
        object = statusLine.getReasonPhrase() + " [" + statusLine.getStatusCode() + "]";
        if (string != null) {
            object = (String)object + "\nResponse content: " + string;
        }
        throw new HttpResponseException(statusLine.getStatusCode(), (String)object);
    }
}

