/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.commons.random.VerySecureRandom;
import com.helger.commons.ws.HostnameVerifierVerifyAll;
import com.helger.httpclient.HttpClientFactory;
import com.helger.pd.client.PDClientConfiguration;
import com.helger.peppol.utils.PeppolKeyStoreHelper;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDHttpClientFactory
extends HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDHttpClientFactory.class);

    public PDHttpClientFactory() {
        LoadedKeyStore loadedKeyStore;
        if (PDClientConfiguration.isHttpsHostnameVerificationDisabled()) {
            this.setHostnameVerifier((HostnameVerifier)new HostnameVerifierVerifyAll(false));
        }
        if ((loadedKeyStore = KeyStoreHelper.loadKeyStore((IKeyStoreType)PDClientConfiguration.getKeyStoreType(), (String)PDClientConfiguration.getKeyStorePath(), (String)PDClientConfiguration.getKeyStorePassword())).isFailure()) {
            LOGGER.error("Failed to initialize keystore for service connection! Can only use http now! Details: " + PeppolKeyStoreHelper.getLoadError((LoadedKeyStore)loadedKeyStore));
        } else {
            LoadedKeyStore loadedKeyStore2 = KeyStoreHelper.loadKeyStore((IKeyStoreType)PDClientConfiguration.getTrustStoreType(), (String)PDClientConfiguration.getTrustStorePath(), (String)PDClientConfiguration.getTrustStorePassword());
            KeyStore keyStore = loadedKeyStore2.getKeyStore();
            try {
                this.setSSLContext(SSLContexts.custom().loadKeyMaterial(loadedKeyStore.getKeyStore(), PDClientConfiguration.getKeyStoreKeyPassword(), (map, socket) -> {
                    String string;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("chooseAlias(" + map + ", " + socket + ")");
                    }
                    return map.containsKey(string = PDClientConfiguration.getKeyStoreKeyAlias()) ? string : null;
                }).loadTrustMaterial(keyStore, (x509CertificateArray, string) -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("isTrusted(" + Arrays.toString(x509CertificateArray) + ", " + string + ")");
                    }
                    return true;
                }).setSecureRandom(VerySecureRandom.getInstance()).build());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalStateException("Failed to create SSL context", generalSecurityException);
            }
        }
    }

    @Nonnull
    public RequestConfig.Builder createRequestConfigBuilder() {
        RequestConfig.Builder builder = super.createRequestConfigBuilder();
        builder.setConnectTimeout(PDClientConfiguration.getConnectTimeoutMS());
        builder.setSocketTimeout(PDClientConfiguration.getRequestTimeoutMS());
        return builder;
    }
}

